% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGrid.R
\name{plotGrid}
\alias{plotGrid}
\title{Plots raster layers of a raster stack object}
\usage{
plotGrid(long.name, plot.me, irregular = FALSE,
  my.projection = "+proj=longlat +ellps=WGS84",
  shp.filename = system.file("extdata/ne_110m_land/ne_110m_land.shp",
  package = "amber"), my.xlim = c(-180, 180), my.ylim = c(-60, 85),
  plot.width = 8, plot.height = 3.8, outputDir = FALSE)
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{plot.me}{A list that is produced by \link{scores.grid.time} or
\link{scores.grid.notime}.}

\item{irregular}{logical: TRUE if data is on an irregular grid and FALSE if
data is on a regular grid}

\item{my.projection}{A string that gives the projection of the irregular grid}

\item{shp.filename}{A string that gives the coastline shapefile}

\item{my.xlim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-180, 180)}

\item{my.ylim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory.}
}
\value{
Figures in PDF format.
This may include the model data
(mean, \eqn{mod.mean}; standard deviation; interannual-variability, \eqn{mod.iav}; month of
annual cycle maximum, \eqn{mod.max.month}),
the reference data
(mean, \eqn{ref.mean}; standard deviation; interannual-variability, \eqn{ref.iav}; month of
annual cycle maximum, \eqn{ref.max.month}),
statistical metrics
(bias, \eqn{bias}; root mean square error, \eqn{rmse}; time difference of the
 annual cycle maximum, \eqn{phase}),
and scores
(bias score, \eqn{bias.score}; root mean square error score,
\eqn{rmse.score}; inter-annual variability score \eqn{iav.score};
annual cycle score (\eqn{phase.score}).
}
\description{
This function plots the results from \link{scores.grid.time} and
\link{scores.grid.notime}.
}
\examples{

\donttest{
# (1) Global plots on a regular grid

library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

long.name <- 'Gross primary productivity'
nc.mod <- system.file('extdata/modelRegular', 'gpp_monthly.nc', package = 'amber')
nc.ref <- system.file('extdata/referenceRegular', 'gpp_GBAF_128x64.nc', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'GBAF' # give reference dataset a name
unit.conv.mod <- 86400*1000 # optional unit conversion for model data
unit.conv.ref <- 86400*1000 # optional unit conversion for reference data
variable.unit <- 'gC m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)

# Short version using default settings:
plot.me <- scores.grid.time(long.name, nc.mod, nc.ref, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit)
plotGrid(long.name, plot.me)

plot.me <- scores.grid.time(long.name, nc.mod, nc.ref, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit, score.weights = c(1,2,1,1,1), outlier.factor = 1,
irregular = FALSE)
plotGrid(long.name, plot.me)

# (2) Regional plots on a rotated grid
long.name <- 'Gross primary productivity'
nc.mod <- system.file('extdata/modelRotated', 'gpp_monthly.nc', package = 'amber')
nc.ref <- system.file('extdata/referenceRotated', 'gpp_GBAF_rotated.nc', package = 'amber')
mod.id <- 'CLASSIC' # define a model experiment ID
ref.id <- 'GBAF' # give reference dataset a name
unit.conv.mod <- 86400*1000 # optional unit conversion for model data
unit.conv.ref <- 86400*1000 # optional unit conversion for reference data
variable.unit <- 'gC m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)
my.projection <- '+proj=ob_tran +o_proj=longlat +o_lon_p=83. +o_lat_p=42.5 +lon_0=263.'

plot.me <- scores.grid.time(long.name, nc.mod, nc.ref, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit, score.weights = c(1,2,1,1,1), outlier.factor = 10,
irregular = TRUE, my.projection = my.projection)

# Plot results:
irregular <- TRUE # data is on an irregular grid
my.projection <- '+proj=ob_tran +o_proj=longlat +o_lon_p=83. +o_lat_p=42.5 +lon_0=263.'
# shp.filename <- system.file('extdata/ne_50m_admin_0_countries/ne_50m_admin_0_countries.shp',
# package = 'amber')
shp.filename <- system.file("extdata/ne_110m_land/ne_110m_land.shp", package = "amber")
my.xlim <- c(-171, 0) # longitude range that you wish to plot
my.ylim <- c(32, 78) # latitude range that you wish to plot
plot.width <- 7 # plot width
plot.height <- 3.8 # plot height

plotGrid(long.name, plot.me, irregular, my.projection,
shp.filename, my.xlim, my.ylim, plot.width, plot.height)
} #donttest
}
