% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.runoff.R
\name{scores.runoff}
\alias{scores.runoff}
\title{Scores for runoff}
\usage{
scores.runoff(long.name, nc.mod, nc.ref, nc.basins, mod.id, ref.id,
  unit.conv.mod, unit.conv.ref, variable.unit, score.weights = c(1, 2, 1,
  1, 1),
  shp.filename = system.file("extdata/ne_110m_land/ne_110m_land.shp",
  package = "amber"), my.xlim = c(-180, 180), my.ylim = c(-60, 85),
  plot.width = 8, plot.height = 3.8, outputDir = FALSE,
  subcaption = "")
}
\arguments{
\item{long.name}{A string that gives the full name of the variable, e.g. 'Gross primary productivity'}

\item{nc.mod}{A string that gives the path and name of the netcdf file that contains the model output, e.g. '/home/model_gpp.nc'}

\item{nc.ref}{A string that gives the path and name of the netcdf file that contains the reference data output, e.g. '/home/reference_gpp.nc'}

\item{nc.basins}{A string that gives the path and name of the netcdf file that contains the river basins, e.g. '/home/basins.nc'}

\item{mod.id}{A string that identifies the source of the reference data set, e.g. 'CanESM2'}

\item{ref.id}{A string that identifies the source of the reference data set, e.g. 'MODIS'}

\item{unit.conv.mod}{A number that is used as a factor to convert the unit of the model data, e.g. 86400}

\item{unit.conv.ref}{A number that is used as a factor to convert the unit of the reference data, e.g. 86400}

\item{variable.unit}{A string that gives the final units using LaTeX notation, e.g. 'gC m$^{-2}$ day$^{-1}$'}

\item{score.weights}{R object that gives the weights of each score (\eqn{S_{bias}}, \eqn{S_{rmse}}, \eqn{S_{phase}}, \eqn{S_{iav}}, \eqn{S_{dist}})
that are used for computing the overall score, e.g. c(1,2,1,1,1)}

\item{shp.filename}{A string that gives the coastline shapefile}

\item{my.xlim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-180, 180)}

\item{my.ylim}{An R object that gives the longitude range that you wish to
plot, e.g. c(-90, 90)}

\item{plot.width}{Number that gives the plot width, e.g. 8}

\item{plot.height}{Number that gives the plot height, e.g. 4}

\item{outputDir}{A string that gives the output directory, e.g. '/home/project/study'. The output will only be written if the user specifies an output directory}

\item{subcaption}{A string that defines the subcaption of the figure, e.g. '(a)'.}
}
\value{
(1) Figures in PDF format that show global maps of
the model data
(mean, \eqn{mod.mean}; interannual-variability, \eqn{mod.iav}),
the reference data
(mean, \eqn{ref.mean}; interannual-variability, \eqn{ref.iav}),
statistical metrics
(bias, \eqn{bias}; centralized root mean square error, \eqn{crmse}),
and scores
(bias score, \eqn{bias.score}; root mean square error score, \eqn{rmse.score}; inter-annual variability score \eqn{iav.score}).

(2) Three text files: (i) score values and (ii) score inputs averaged across
the entire grid, and (iii) score values for each individual river basin.
}
\description{
This function compares modelled runoff and measured streamflow
on an annual basis for 50 river basins. Modelled runoff is converted to
streamflow by spatially integrating annual runoff across each river basins.
The performance of a model is expressed through scores that range from
zero to one, where increasing values imply better performance. These scores
are computed in five steps:
\eqn{(i)} computation of a statistical metric,
\eqn{(ii)} nondimensionalization,
\eqn{(iii)} conversion to unit interval,
\eqn{(iv)} spatial integration, and
\eqn{(v)} averaging scores computed from different statistical metrics.
The latter includes the bias, root-mean-square error,
inter-annual variability, and spatial distribution. The corresponding equations
are documented in \code{\link{amber-package}}. Contrary to the function
\link{scores.grid.time}, no phase score is computed since data is evaluated on
an annual basis. Assessing annual rather than monthly values causes the standard
deviation \eqn{sigma_{ref}(\lambda, \phi)} to be very small. For this reason,
the relative errors for runoff are computed with repect to the mean rather than
the standard deviation:

\eqn{(ii) \ \varepsilon_{bias}=|bias(\lambda, \phi)|/\overline{v_{ref}}(\lambda, \phi)}
\eqn{(ii) \ \varepsilon_{rmse}(\lambda, \phi)=crmse(\lambda, \phi)/\overline{v_{ref}}(\lambda, \phi).}
}
\examples{

\donttest{
library(amber)
library(classInt)
library(doParallel)
library(foreach)
library(Hmisc)
library(latex2exp)
library(ncdf4)
library(parallel)
library(raster)
library(rgdal)
library(rgeos)
library(scico)
library(sp)
library(stats)
library(utils)
library(viridis)
library(xtable)

long.name <- 'Streamflow'
nc.mod <- system.file('extdata/modelRegular', 'mrro_monthly.nc', package = 'amber')
nc.ref <- system.file('extdata/referenceRegular', 'runoff.nc', package = 'amber')
nc.basins <- system.file('extdata/referenceRegular', 'basins.nc', package = 'amber')
mod.id <- 'CLASSIC' # model name
ref.id <- 'GRDC' # give reference dataset a name
unit.conv.mod <- 86400 # optional unit conversion for model data
unit.conv.ref <- 86400 # optional unit conversion for reference data
variable.unit <- 'kg m$^{-2}$ day$^{-1}$' # unit after conversion (LaTeX notation)
score.weights <- c(1,2,1,1,1) # define score weights

scores.runoff(long.name, nc.mod, nc.ref, nc.basins, mod.id, ref.id, unit.conv.mod,
unit.conv.ref, variable.unit, score.weights)
} #donttest
}
