% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_options.R
\name{do_options}
\alias{do_options}
\title{Set Digital Ocean options including ssh keys, etc.}
\usage{
do_options(size = NULL, image = NULL, region = NULL, ssh_keys = NULL,
  private_networking = NULL, backups = NULL, ipv6 = NULL, unset = FALSE)
}
\arguments{
\item{size}{(optional) A Digital Ocean size slug name, e.g. '1gb'. Saved in
options as 'do_size'}

\item{image}{(optional) A Digital Ocean image name, e.g., 'ubuntu-14-04-x64'.
Saved in options as 'do_image'}

\item{region}{(optional) A Digital Ocean region name, e.g., 'nyc1'. Saved
in options as 'do_region'}

\item{ssh_keys}{(optional) One or more ssh key id numbers or fingerprints.
Put many in a list or vector. Saved in options as 'do_ssh_keys'}

\item{private_networking}{(optional) A logical, whether to use private
networking or not. Saved in options as 'do_private_networking'}

\item{backups}{(optional) A logical, whether to enable backups. Automated
backups can only be enabled when the Droplet is created. Saved in options
as 'do_backups'}

\item{ipv6}{(optional) A boolean indicating whether IPv6 is enabled on
the Droplet. Saved in options as 'do_ipv6'}

\item{unset}{(optional) A boolean. If TRUE, unsets options so as to use
defaults in
\code{\link{droplet_create}}. If \code{FALSE} (default) your options are
used in \code{\link{droplet_create}}.}
}
\description{
This function sets options and prints them so you know what options are set.
}
\details{
These options are read and used by \code{\link{droplet_create}}.

You can only set one value for each of size, image, and region, but multiple
values for ssh_keys as you can use multiple ssh keys on one DO droplet.

Keep in mind that there are defaults set for size, image, and region
in \code{\link{droplet_create}}.
}
\examples{
\dontrun{
do_options()
do_options(ssh_keys=89103)
getOption('do_ssh_keys')
do_options(size="8gb")
do_options(size="1gb", image='ubuntu-14-04-x64', region='nyc1')
getOption('do_size')
getOption('do_image')
getOption('do_region')
}
}
