% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-functions.R
\docType{methods}
\name{setInput}
\alias{setInput}
\alias{setInput,BaseAnalysisPipeline-method}
\title{Sets the input for an \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object}
\usage{
setInput(object, input, filePath = "")

\S4method{setInput}{BaseAnalysisPipeline}(object, input, filePath = "")
}
\arguments{
\item{object}{object that contains input, pipeline, registry and output}

\item{input}{the input data frame}

\item{filePath}{path to the file which needs to be read (currently supports .csv files)}
}
\value{
Updated \code{AnalysisPipeline} \code{StreamingAnalysisPipeline} object
}
\description{
Sets the input for an \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object
}
\details{
Assigns the input to the pipeline for an  \code{AnalysisPipeline} or \code{StreamingAnalysisPipeline} object

This method is implemented on the base class as it is a shared functionality types of Analysis Pipelines
which extend this class
}
\examples{
  library(analysisPipelines)
  pipelineObj <- AnalysisPipeline()
  pipelineObj \%>>\% setInput(input = iris) -> pipelineObj
}
\seealso{
Other Package core functions: \code{\link{BaseAnalysisPipeline-class}},
  \code{\link{MetaAnalysisPipeline-class}},
  \code{\link{assessEngineSetUp}},
  \code{\link{checkSchemaMatch}},
  \code{\link{createPipelineInstance}},
  \code{\link{exportAsMetaPipeline}},
  \code{\link{generateOutput}},
  \code{\link{genericPipelineException}},
  \code{\link{getInput}}, \code{\link{getLoggerDetails}},
  \code{\link{getOutputById}},
  \code{\link{getPipelinePrototype}},
  \code{\link{getPipeline}}, \code{\link{getRegistry}},
  \code{\link{initDfBasedOnType}},
  \code{\link{initialize,BaseAnalysisPipeline-method}},
  \code{\link{loadMetaPipeline}},
  \code{\link{loadPipeline}},
  \code{\link{loadPredefinedFunctionRegistry}},
  \code{\link{loadRegistry}}, \code{\link{prepExecution}},
  \code{\link{registerFunction}},
  \code{\link{savePipeline}}, \code{\link{saveRegistry}},
  \code{\link{setLoggerDetails}},
  \code{\link{updateObject}},
  \code{\link{visualizePipeline}}
}
\concept{Package core functions}
