% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEL-model.R
\name{DEL}
\alias{DEL}
\alias{DEL.default}
\alias{DEL.PATH0}
\alias{DEL.TRI}
\alias{DEL.TRI0}
\alias{DEL.SC}
\alias{DEL.SC0}
\alias{DEL.PATH}
\title{Convert object to a constrained-Delaunay triangulation}
\usage{
DEL(x, ..., max_area = NULL)

\method{DEL}{default}(x, ..., max_area = NULL)

\method{DEL}{PATH0}(x, ..., max_area = NULL)

\method{DEL}{TRI}(x, ..., max_area = NULL)

\method{DEL}{TRI0}(x, ..., max_area = NULL)

\method{DEL}{SC}(x, ..., max_area = NULL)

\method{DEL}{SC0}(x, ..., max_area = NULL)

\method{DEL}{PATH}(x, ..., max_area = NULL)
}
\arguments{
\item{x}{input model}

\item{...}{passed to the underlying Triangle library, see \link[RTriangle:triangulate]{RTriangle::triangulate()}}

\item{max_area}{the maximum area of a triangle}
}
\value{
DEL model
}
\description{
This \emph{relational-form} Delaunay-based triangulation model is analogous to the
'TRI' model in the silicate package and formally extends the class of that
model. A primitives-based shape-constrained triangulation. The Delaunay model
is the \emph{mostly Delaunay} scheme used by the provable-quality meshers.
}
\details{
Compare \code{\link[=DEL]{DEL()}} to its \emph{structural-form} counterpart \code{\link[=DEL0]{DEL0()}}. \code{DEL()}
records a \code{visible} property on the triangle table, and this is queried by
other functions for the status of triangles that belonged to a hole within a
surface. These triangle are obviously useful, so they are kept but default to
\code{visible = FALSE} and so are not plotted.

The Delaunay model is a constrained triangulation with a variety of
constraint and qualification types. The Delaunay model has the odd but
defining characteristic of not being always consistent with the Delaunay
criterion. Edge inclusion is non-negotiable, but other constraints include
(limit, or avoid) Steiner vertex insertion, a limit on the maximum area of a
triangle, minimum triangle angle and strict adherence to the Delaunay
criterion.

The Delaunay criterion forms the basis of this model, and is its defining
characteristic without being strictly adhered to. This is awkward to describe
but is the key property. From Wikipedia: The "Delaunay triangulation (also
known as a Delone triangulation) for a given set P of discrete points in a
plane is a triangulation DT(P) such that no point in P is inside the
circumcircle of any triangle in DT(P). Delaunay triangulations maximize the
minimum angle of all the angles of the triangles in the triangulation; they
tend to avoid sliver triangles. . . . The Delaunay triangulation corresponds
to the dual graph of the Voronoi diagram of P"
\url{https://en.wikipedia.org/wiki/Delaunay_triangulation}.

This strict criterion is \emph{relaxed} in small measure, to ensure that all
edge-inputs are preserved and to allow further constraints such as triangle
size and internal angle to be specified.
}
\section{Warning}{


Please take care with the \code{max_area} argument. The units are not taken into
account, the value refers only to the planar area of the x/y coordinates as
they are so this is not a real world area, but a mathematical property of the
data. There is a safety check for a very large number of triangles, and this
may be overridden by replying 'Yes' to the prompt.
}

\section{Topology}{


The DEL model cannot currently mesh point features, and it cannot mesh
linear features if they include z or other vertex attributes - for now use
\code{\link[=DEL0]{DEL0()}} which can do those.
}

\section{Licensing}{


The anglr package is released with license CC BY-NC-SA 4.0 to match the one
dependency RTriangle. Please note and respect the license of the RTriangle
package used by the \code{\link[=DEL]{DEL()}} or \code{\link[=DEL0]{DEL0()}} functions in anglr, and invoked
within 3D plot methods. These return high-quality constrained Delaunay
triangulations of polygonal regions, with the ability to control mesh
characteristics including maximum triangle area, minimum internal angle, and
conformance to the Delaunay criterion. If you are interested in
a less restrictive license for high-quality meshing in R please
get involved with \href{https://github.com/hypertidy/laridae}{the laridae package}
which aims to provide access to \href{https://www.cgal.org/}{CGAL}.
}

\examples{
plot3d(DEL(simpleworld))
}
\seealso{
\link{DEL0} \link[silicate:TRI]{TRI} \link[silicate:TRI0]{TRI0}
}
