% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsampling_analysis.R
\name{network_subsamples}
\alias{network_subsamples}
\title{To generate subsamples and obtain network metrics of the subsamples}
\usage{
network_subsamples(
  network,
  n_simulations = 100,
  subsampling_proportion = c(0.1, 0.3, 0.5, 0.7, 0.9),
  network_metrics = c("density", "mean_strength", "diameter", "transitivity")
)
}
\arguments{
\item{network}{An igraph graph object consisting of observed network}

\item{n_simulations}{Number of sub-samples to be obtained at each level}

\item{subsampling_proportion}{A vector depicting the levels (in proportion) at which subsamples to be taken}

\item{network_metrics}{A vector depicting names of global network metrics. Default = network_metrics = c("density", "mean_strength", "diameter", "transitivity")}
}
\value{
A list of network metrics of class "Subsampled_Network_Metrics". Each element of list is a matrix whose columns 
        correspond to subsampling_proportion and rows correspond to n_simulations. 
        The entries of the matrix provide values of the corresponding metric.
}
\description{
To generate subsamples and obtain network metrics of the subsamples
}
\examples{

data(elk_network_2010)
network_subsamples(elk_network_2010)

}
