% Generated by roxygen2 (4.0.2): do not edit by hand
\name{anim.segments}
\alias{anim.arrowplot}
\alias{anim.arrows}
\alias{anim.segmentplot}
\alias{anim.segments}
\title{Draw an animation of line segments or arrows.}
\usage{
anim.segments(x0, y0, x1 = NULL, y1 = NULL, times = NULL, speed = 1,
  show = TRUE, use.times = TRUE, window = t, window.process = NULL,
  fn = segments, col = NULL, lty = NULL, lwd = NULL, ...)

anim.arrows(..., length = 0.25, angle = 30, code = 2)

anim.segmentplot(...)

anim.arrowplot(...)
}
\arguments{
\item{x0,y0,x1,y1,col,lty,lwd,length,angle,code,...}{arguments passed to \code{\link{segments}} or
\code{\link{arrows}}}

\item{times,speed,show,use.times,window,window.process}{see \code{\link{anim.plot}} for details}

\item{fn}{underlying function to use}
}
\description{
Draw an animation of line segments or arrows.
}
\details{
\code{anim.segments} and \code{anim.arrows} draw lines on to an existing plot.
If you want to redraw the plot between each frame, use \code{anim.arrowplot}
or \code{anim.segmentplot}.

If both \code{x1} and \code{y1} are missing, then segments are plotted
from the current time to the following time in each frame. If only \code{x1}
is missing it is set equal to \code{x0}, similarly if only \code{y1} is
missing.
}
\examples{
anim.segments(x0=rep(1:5, 5), y0=rep(1:5, each=5), y1=rep(2:6, each=5),
     times=rep(1:5, each=5) )

## Short version
anim.arrowplot(rep(1:5, 5), rep(1:5, each=5), times=5)

if (require('maps')) {
   hr <- subset(hurricanes, lat > 0 & lat < 50 & lon > -95 & lon < -20 &
         Shour \%\% 6 == 0)
   hr$dlat <- cos(hr$diruv/360*2*pi) * hr$maguv / 8
   hr$dlon <- sin(hr$diruv/360*2*pi) * hr$maguv / 8
   hr$name <- sub("\\\\s+$", "", hr$name)
   map('world', xlim=c(-95,-20), ylim=c(0,50))
   title("Hurricanes, 2009")
   with(hr[!duplicated(hr$name),], text(lon, lat,
         labels=paste0(name, "\\n", Yr), cex=0.8))
   with(hr, anim.arrows(x0=lon, y0=lat, y1=lat+dlat, x1=lon+dlon,
         times=Shour, speed=12, col=rgb(0,0,1,0.8), length=.1, lwd=2))
}
}

