% Generated by roxygen2 (4.0.2): do not edit by hand
\name{merge.anim.frames}
\alias{merge.anim.frames}
\title{Merge anim.frames objects}
\usage{
\method{merge}{anim.frames}(..., speed = NULL)
}
\arguments{
\item{...}{anim.frames objects returned from, e.g. \code{\link{anim.plot}}}

\item{speed}{speed for the merged object. This may be left unspecified only
   if all objects have the same speed.}
}
\description{
Merge two or more anim.frames objects to create a new anim.frames object
}
\details{
If two or more calls in the merged animation are at the same time, calls
from the earlier object in \code{...} will be run first.

If you merge two animations from \code{\link{anim.plot}}, plot.window will be
called before each frame of the merged animation. This may not be what
you want. Instead, use \code{anim.points} or similar for all but the first
animation.
}
\examples{
tmp <- anim.plot(1:5, 1:5, speed=2)
tmp2 <- anim.plot(1:5, 5:1, col="red", speed=2)
## Not what you want:
replay(merge(tmp, tmp2))

## better:
tmp3 <- anim.points(1:5, 5:1,col="red", speed=2)
newf <- merge(tmp, tmp3)
replay(newf)
## NB: result of the merge looks different from the two
## individual animations

## not the same:
newf2 <- merge(tmp2, tmp)
## points will be called before plot!
replay(newf2)
}

