% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anim-prep.R
\name{anim_prep}
\alias{anim_prep}
\title{Transformed numerical into categorized data}
\usage{
anim_prep(
  data,
  id = NULL,
  values = NULL,
  time = NULL,
  group = NULL,
  ncat = 5L,
  breaks = NULL,
  label = NULL,
  group_scaling = NULL,
  scaling = "rank"
)
}
\arguments{
\item{data}{A data frame contained the numerical values.}

\item{id}{The column name that represents the identifiers variable.}

\item{values}{The column name contains the numeric values.}

\item{time}{The column name that represents the time variable.}

\item{group}{The column name that represents the distinguished group between
the values.}

\item{ncat}{The number of categories to be created for scaling values.}

\item{breaks}{A vector of breaks for creating bins.}

\item{label}{A vector of labels to represent the qtile.}

\item{group_scaling}{The column name that will be used for grouping the
variable before scaling.}

\item{scaling}{The scaling method to be used; "rank" or "absolute".}
}
\value{
A categorized data.
}
\description{
This function transformed the numerical data into the categorized format by
grouping data and scaling values.
}
\details{
The function takes the input data and performs several operations to
transformed it into categorized format. It is done by grouping data, scales
values, and assigned the qtile.
}
\examples{
# rank scaling
anim_prep(data = osiris, id = ID, values = sales, time = year)

# group_rank scaling
anim_prep(data = osiris, id = ID, values = sales, time = year,
group_scaling = country)

# absolute scaling
anim_prep(data = osiris, id = ID, values = sales, time = year,
scaling = "absolute")

# group_absolute scaling
anim_prep(data = osiris, id = ID, values = sales, time = year,
group_scaling = country, scaling = "absolute")

}
