% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-nudge.R
\name{position_nudge}
\alias{position_nudge}
\title{Nudge points.}
\usage{
position_nudge(x = 0, y = 0)
}
\arguments{
\item{x, y}{Amount of vertical and horizontal distance to move.}
}
\description{
This is useful if you want to nudge labels a little ways from their
points.
}
\examples{
df <- data.frame(
  x = c(1,3,2,5),
  y = c("a","c","d","c")
)

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y))

ggplot(df, aes(x, y)) +
  geom_point() +
  geom_text(aes(label = y), position = position_nudge(y = -0.1))
}
\seealso{
Other position adjustments: 
\code{\link{position_dodge}()},
\code{\link{position_fill}()},
\code{\link{position_identity}()},
\code{\link{position_jitterdodge}()},
\code{\link{position_jitter}()}
}
\concept{position adjustments}
