/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.optional.image;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.PlanarImage;
import org.apache.tools.ant.types.optional.image.ColorMapper;
import org.apache.tools.ant.types.optional.image.DrawOperation;
import org.apache.tools.ant.types.optional.image.ImageOperation;

public class Text
extends ImageOperation
implements DrawOperation {
    private static final int DEFAULT_POINT = 10;
    private String strText = "";
    private String font = "Arial";
    private int point = 10;
    private boolean bold = false;
    private boolean italic = false;
    private String color = "black";

    public void setString(String str) {
        this.strText = str;
    }

    public void setFont(String f) {
        this.font = f;
    }

    public void setPoint(String p) {
        this.point = Integer.parseInt(p);
    }

    public void setColor(String c) {
        this.color = c;
    }

    public void setBold(boolean state) {
        this.bold = state;
    }

    public void setItalic(boolean state) {
        this.italic = state;
    }

    public PlanarImage executeDrawOperation() {
        this.log("\tCreating Text \"" + this.strText + "\"");
        Color couloir = ColorMapper.getColorByName(this.color);
        int width = 1;
        int height = 1;
        BufferedImage bi = new BufferedImage(width, height, 7);
        Graphics2D graphics = (Graphics2D)bi.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        Font f = new Font(this.font, 0, this.point);
        FontMetrics fmetrics = graphics.getFontMetrics(f);
        height = fmetrics.getMaxAscent() + fmetrics.getMaxDescent();
        width = fmetrics.stringWidth(this.strText);
        bi = new BufferedImage(width, height, 7);
        graphics = (Graphics2D)bi.getGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setFont(f);
        graphics.setColor(couloir);
        graphics.drawString(this.strText, 0, height - fmetrics.getMaxDescent());
        PlanarImage image = PlanarImage.wrapRenderedImage((RenderedImage)bi);
        return image;
    }
}

