% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExternalDependency.R
\name{externalDependency}
\alias{externalDependency}
\title{External Dependencies in imports and exports}
\usage{
externalDependency(x, timeStep = "annual", synthesis = FALSE)
}
\arguments{
\item{x}{An object created with function \code{\link[antaresRead]{readAntares}}. It
  must contain data for areas and/or distritcs . More specifically this
  function requires the columns \code{hstorPMaxAvg}, and \code{netLoad}. To
  get these columns, one has to invoke \code{\link[antaresRead]{readAntares}}
  with the parameter \code{hydroStorageMaxPower = TRUE} and
  \code{\link[antaresProcessing]{addNetLoad}} (see examples).

  Moreover it needs to have a hourly time step.

  This object must also contain linkCapacity if there was virtual areas
  remove by \code{\link[antaresRead]{removeVirtualAreas}} to be able to
  calculate pumping and storage capacities.}

\item{timeStep}{Desired time step for the result.}

\item{synthesis}{If TRUE, average external dependncies are returned. Else the function
returns external dependncies per Monte-Carlo scenario.}
}
\value{
A data.table of class \code{antaresDataTable} with the following columns:
\item{area}{Area name.}
\item{timeId}{Time id and other time columns.}
\item{pumping}{capacity of pumping}
\item{storage}{capacity of storage}
\item{exportsLevel}{netLoad + pumping}
\item{importsLevel}{netLoad - `AVL DTG` - hydroStorageMaxPower - storage > 0}
\item{exportsFrequency}{number of time step where this criteria is satisfied

  criteria : netLoad + pumping < 0
}
\item{importsFrequency}{number of time step where this criteria is satisfied

  criteria : netLoad - `AVL DTG` - hydroStorageMaxPower - storage > 0
}
}
\description{
This function computes the dependency in imports and export for each area or districts at a
given time step. Dependency in imports represents moments where imports are required
to have no loss of load. Depandency in exports represents moments where exports are required to
have no spilled energy.
}
\examples{
\dontrun{
# Data required by the function
showAliases("externalDependency")

mydata <- readAntares(select = "externalDependency")
addNetLoad(mydata)
externalDependency(mydata)

# if there are some virtual pumping/storage areas, remove them with
# removeVirtualAreas
mydata <- removeVirtualAreas(mydata, c("pumping", "storage"))
externalDependency(mydata, ignoreMustRun = TRUE)
}

}
