% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDownwardMargin.R
\name{addDownwardMargin}
\alias{addDownwardMargin}
\title{Add downward margins of areas}
\usage{
addDownwardMargin(x)
}
\arguments{
\item{x}{An object of class \code{\link[antaresRead]{readAntares}} (or \code{\link[antaresRead]{simOptions}}) created with 'readAntares()' (or 'setSimulationPath()')}
}
\value{
The function modifies its input by adding to it two new columns
\code{isolatedDownwardMargin} and \code{interconnectedDownwardMargin}. For
convenience it invisibly returns \code{x}.
}
\description{
This function computes isolated and interconnected downward margins of areas and
add them to an antaresData object.
}
\details{
For a given area, downward margin is equal to the thermal minimum production
(due must run production and minimum stable power of production units) plus
the fatal productions minus the load and the pumping capacity. More formally
it is equal to:

\code{isolatedDownwardMargin = thermalPMin + `H. ROR` + WIND + SOLAR + `MISC. NDG`
                               - LOAD - pumpingCapacity}

The variable \code{pumpingCapacity} is automatically created when pumped
storage areas are removed with function
\code{\link[antaresRead]{removeVirtualAreas}}. If there is not any such area,
\code{pumpingCapacity} is assumed to be equal to 0.

Interconnected downward margin is the isolated downward margin plus the exports
minus the imports:

\code{interconnectedDownwardMargin = isolatedDownwardMargin + BALANCE - `ROW BAL.`}
}
\examples{
\dontrun{
# data required by the function
showAliases("downwardMargin")

mydata <- readAntares(select = "downwardMargin")
mydata <- removeVirtualAreas(mydata, getAreas(c("pump", "stor")))

addDownwardMargin(mydata)
names(mydata$areas)
}
}
