% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_flights.R
\name{get_flights}
\alias{get_flights}
\title{Query nycflights13-Like Flights Data}
\source{
RITA, Bureau of transportation statistics,
 \url{http://www.transtats.bts.gov}
}
\usage{
get_flights(station, year, month = 1:12, dir = NULL, ...)
}
\arguments{
\item{station}{A character vector giving the origin US airports of interest
(as the FAA LID airport code).}

\item{year}{A numeric giving the year of interest. This argument is currently
not vectorized, as dataset sizes for single years are significantly large.
Information for the most recent year is usually available by February or 
March in the following year.}

\item{month}{A numeric giving the month(s) of interest.}

\item{dir}{An optional character string giving the directory
to save datasets in. By default, datasets will not be saved to file.}

\item{...}{Currently only used internally.}
}
\value{
A data frame with ~1k-500k rows and 19 variables:
\describe{
\item{\code{year, month, day}}{Date of departure}
\item{\code{dep_time, arr_time}}{Actual departure and arrival times, UTC.}
\item{\code{sched_dep_time, sched_arr_time}}{Scheduled departure and arrival 
  times, UTC.}
\item{\code{dep_delay, arr_delay}}{Departure and arrival delays, in minutes.
  Negative times represent early departures/arrivals.}
\item{\code{hour, minute}}{Time of scheduled departure broken into hour and 
  minutes.}
\item{\code{carrier}}{Two letter carrier abbreviation. See 
  \code{\link{get_airlines}} to get full name}
\item{\code{tailnum}}{Plane tail number}
\item{\code{flight}}{Flight number}
\item{\code{origin, dest}}{Origin and destination. See 
  \code{\link{get_airports}} for additional metadata.}
\item{\code{air_time}}{Amount of time spent in the air, in minutes}
\item{\code{distance}}{Distance between airports, in miles}
\item{\code{time_hour}}{Scheduled date and hour of the flight as a 
  \code{POSIXct} date. Along with \code{origin}, can be used to join 
  flights data to weather data.}
}
}
\description{
This function generates a dataframe similar to the 
\code{\link[nycflights13]{flights}} dataset from \code{nycflights13} 
for any US airport and time frame. Please 
note that, even with a strong internet connection, this function 
may take several minutes to download relevant data.
}
\details{
This function currently downloads data for \emph{all} stations for each month
supplied, and \emph{then} filters out data for relevant stations. Thus, 
the recommended approach to download data for many airports is to supply 
a vector of airport codes to the \code{station} argument rather than 
iterating over many calls to \code{get_flights()}.
}
\examples{

# flights out of Portland International in June 2018
\donttest{\dontrun{get_flights("PDX", 2018, 6)}}

# ...or the original nycflights13 flights dataset
\donttest{\dontrun{get_flights(c("JFK", "LGA", "EWR"), 2013)}}

# use the dir argument to indicate the folder to 
# save the data in \code{dir} as "flights.rda"
\donttest{\dontrun{get_flights("PDX", 2018, 6, dir = tempdir())}}

}
\seealso{
\code{\link{get_weather}} for weather data, 
\code{\link{get_airlines}} for airlines data,
\code{\link{get_airports}} for airports data,
\code{\link{get_planes}} for planes data,
or \code{\link{anyflights}} for a wrapper function.

Use the \code{\link{as_flights_package}} function to convert this dataset 
to a data-only package.
}
