% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{getFormats}
\alias{addFormats}
\alias{getFormats}
\title{Functions to retrieve (or set) formats used for parsing dates.}
\usage{
getFormats()

addFormats(fmt)
}
\arguments{
\item{fmt}{A vector of character values in the form understood by Boost
date_time}
}
\value{
Nothing in the case of \code{addFormats}; a character vector of
formats in the case of \code{getFormats}
}
\description{
The time and date parsing and conversion relies on trying a (given
and fixed) number of timeformats. The format used is the one employed
by the underlying implementation of the Boost date_time library.
}
\examples{
  getFormats()
  addFormats(c("\%d \%b \%y",      # two-digit date [not recommended], textual month
               "\%a \%b \%d \%Y"))  # weekday weeknumber four-digit year
}
\author{
Dirk Eddelbuettel
}
\seealso{
\code{\link{anytime-package}} and references therein
}

