% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_chart}
\alias{ax_chart}
\title{Chart parameters}
\usage{
ax_chart(ax, type = NULL, stacked = NULL, stackType = NULL,
  animations = NULL, background = NULL, foreColor = NULL,
  dropShadow = NULL, events = NULL, offsetX = NULL, offsetY = NULL,
  selection = NULL, sparkline = NULL, toolbar = NULL, zoom = NULL,
  width = NULL, height = NULL, ...)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{type}{Specify the chart type. Available Options: \code{"bar"}, \code{"column"}, \code{"line"},
\code{"pie"}, \code{"donut"}, \code{"radialBar"}, \code{"scatter"}, \code{"bubble"}, \code{"heatmap"}.}

\item{stacked}{Logical. Enables stacked option for axis charts.}

\item{stackType}{When stacked, should the stacking be percentage based or normal stacking. Available options: \code{"normal"} or \code{"100\%"}}

\item{animations}{A list of parameters.}

\item{background}{Background color for the chart area. If you want to set background with css, use \code{.apexcharts-canvas} to set it.}

\item{foreColor}{Sets the text color for the chart. Defaults to \code{#373d3f}.}

\item{dropShadow}{A list of parameters. See \url{https://apexcharts.com/docs/options/chart/dropshadow/}.}

\item{events}{See \code{\link{events_opts}}.}

\item{offsetX}{Sets the left offset for chart.}

\item{offsetY}{Sets the top offset for chart.}

\item{selection}{A list of parameters.}

\item{sparkline}{List. Sparkline hides all the elements of the charts other than the primary paths. Helps to visualize data in small areas. .}

\item{toolbar}{A list of parameters. See \url{https://apexcharts.com/docs/options/chart/toolbar/}.}

\item{zoom}{A list of parameters. See \url{https://apexcharts.com/docs/options/chart/zoom/}.}

\item{width}{Width of the chart.}

\item{height}{Height of the chart.}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Chart parameters
}
\examples{
library(dplyr)
data("diamonds", package = "ggplot2")

# Stack bar type
apex(
  data = count(diamonds, cut, color),
  mapping = aes(x = cut, y = n, fill = color)
) \%>\% 
  ax_chart(stacked = TRUE)

apex(
  data = count(diamonds, cut, color),
  mapping = aes(x = cut, y = n, fill = color)
) \%>\% 
  ax_chart(stacked = TRUE, stackType = "100\%")


# Toolbar
apex(
  data = count(diamonds, cut, color),
  mapping = aes(x = cut, y = n, fill = color)
) \%>\% 
  ax_chart(toolbar = list(show = FALSE))
}
