% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-options.R
\name{bubble_opts}
\alias{bubble_opts}
\title{Bubble options}
\usage{
bubble_opts(minBubbleRadius, maxBubbleRadius, ...)
}
\arguments{
\item{minBubbleRadius}{Minimum radius size of a bubble.
If a bubble value is too small to be displayed, this size will be used.}

\item{maxBubbleRadius}{Maximum radius size of a bubble.
If a bubble value is too large to cover the chart, this size will be used.}

\item{...}{Additional parameters.}
}
\value{
A \code{list} of options that can be used in \code{\link{ax_plotOptions}}.
}
\description{
Use these options in \code{\link{ax_plotOptions}}.
}
\note{
See \url{https://apexcharts.com/docs/options/plotoptions/bubble/}.
}
\examples{
apex(
  data = mtcars, 
  type = "scatter", 
  mapping = aes(x = wt, y = mpg, z = qsec)
) \%>\% 
  ax_plotOptions(
    bubble = bubble_opts(
      minBubbleRadius = 1,
      maxBubbleRadius = 20
    )
  )
}
