% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-input.R
\name{set_input_click}
\alias{set_input_click}
\title{Retrieve click information in Shiny}
\usage{
set_input_click(
  ax,
  inputId,
  multiple = FALSE,
  effect_type = c("darken", "lighten", "none"),
  effect_value = 0.35,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{ax}{An \code{apexcharts} \code{htmlwidget} object.}

\item{inputId}{The id that will be used server-side for retrieving click.}

\item{multiple}{Allow multiple selection: \code{TRUE} or \code{FALSE} (default).}

\item{effect_type}{Type of effect for selected element, default is to use lightly darken color.}

\item{effect_value}{A larger value intensifies the select effect, accept value between 0 and 1.}

\item{session}{The Shiny session.}
}
\value{
An \code{apexcharts} \code{htmlwidget} object.
}
\description{
According to type of chart, different values are retrieved:
\itemize{
\item \strong{bar and column:} retrieve category (x-axis).
\item \strong{pie and donut:} retrieve label.
\item \strong{time-series:} retrieve x-axis value, you have to display markers
with size > 0 and set tooltip's options \code{intersect = TRUE} and \code{shared = FALSE}.
\item \strong{scatter:} retrieve XY coordinates.
}
}
\note{
If x-axis is of type datetime, value retrieved is of class \code{POSIXct}.
}
\examples{

library(apexcharter)

# Not in Shiny but you can still click on bars
data.frame(
  month = month.abb,
  value = sample(1:100, 12)
) \%>\% 
  apex(aes(month, value)) \%>\% 
  set_input_click("month_click", multiple = TRUE)


# Interactive examples:
if (interactive()) {

  run_demo_input("click")

}
}
