% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-utils.R
\name{ax_subtitle}
\alias{ax_subtitle}
\title{Chart's subtitle}
\usage{
ax_subtitle(
  ax,
  text = NULL,
  align = NULL,
  margin = NULL,
  offsetX = NULL,
  offsetY = NULL,
  floating = NULL,
  style = NULL,
  ...
)
}
\arguments{
\item{ax}{A \code{apexcharts} \code{htmlwidget} object.}

\item{text}{Text to display as a subtitle of chart.}

\item{align}{Alignment of subtitle relative to chart area. Possible Options: \code{"left"}, \code{"center"} and \code{"right"}.}

\item{margin}{Numeric. Vertical spacing around the subtitle text.}

\item{offsetX}{Numeric. Sets the left offset for subtitle text.}

\item{offsetY}{Numeric. Sets the top offset for subtitle text}

\item{floating}{Logical. The floating option will take out the subtitle text from the chart area and make it float on top of the chart.}

\item{style}{List with two items: \code{fontSize} (Font Size of the subtitle text) and \code{color} (Fore color of the subtitle text).}

\item{...}{Additional parameters.}
}
\value{
A \code{apexcharts} \code{htmlwidget} object.
}
\description{
Chart's subtitle
}
\note{
See \url{https://apexcharts.com/docs/options/subtitle/}
}
\examples{
data("economics", package = "ggplot2")
apex(
  data = economics,
  mapping = aes(x = date, y = uempmed),
  type = "line"
) \%>\%
  ax_title(
    text = "Median duration of unemployment"
  ) \%>\%
  ax_subtitle(
    text = "in weeks"
  )
}
