% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_matrix.R
\name{coef_matrix}
\alias{coef_matrix}
\title{Return coefficient matrix}
\usage{
coef_matrix(object)
}
\arguments{
\item{object}{an object of class \code{"lm"}, usually, a result of a
    call to \code{\link[stats]{lm}}.}
}
\value{
A \eqn{p \times 4} matrix with columns for the
  estimated coefficient, its standard error, t-statistic
  and corresponding (two-sided) p-value. Aliased
  coefficients are omitted. The additional class
  \code{coef_matrix} is added for custom printing.
}
\description{
\code{coef_matrix} returns the \code{coefficients}
element of the \code{summary} function, which is a
matrix with columns for the estimated coefficients, their
standard error, t-statistic and corresponding (two-sided)
p-values.
}
\examples{
## a fitted model
fit <- lm(100/mpg ~ disp + hp + wt + am, data = mtcars)
coef_matrix(fit)
print(coef_matrix(fit), digits = 3)
}
\author{
Joshua P. French
}
