% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_detach.R
\name{apollo_detach}
\alias{apollo_detach}
\title{Detaches parameters and the database.}
\usage{
apollo_detach(apollo_beta, apollo_inputs)
}
\arguments{
\item{apollo_beta}{Named numeric vector. Names and values for parameters.}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}
}
\value{
Nothing.
}
\description{
Detaches variables attached by \link{apollo_attach}.
}
\details{
This function detaches the variables attached by \link{apollo_attach}. 
It should be called at the end of \code{apollo_probabilities}, only if 
\link{apollo_attach} was called and the beginning. This can be achieved 
by adding the line \code{on.exit(apollo_detach(apollo_beta, apollo_inputs))} 
right after calling \link{apollo_attach}.
}
\examples{
apollo_beta  <- c(b1=0.3, b2=-0.5)
apollo_fixed <- c()
apollo_control <- list(indivID="id", mixing = FALSE, panelData = FALSE)
database <- data.frame(id=1:100, x1=stats::runif(100), x2=stats::runif(100))
apollo_inputs <- apollo_validateInputs()
apollo_attach(apollo_beta, apollo_inputs)
V = b1*x1 + b2*x2
apollo_detach(apollo_beta, apollo_inputs)
}
