% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wget_apsimx_json.R
\name{insert_replacement_node}
\alias{insert_replacement_node}
\title{Inserts a replacement node in a simple apsimx simulation file}
\usage{
insert_replacement_node(
  file,
  src.dir,
  wrt.dir,
  rep.node,
  rep.node.position = 1,
  new.core.position = rep.node.position + 1,
  edit.tag = "-edited",
  overwrite = FALSE,
  verbose = TRUE,
  root
)
}
\arguments{
\item{file}{file ending in .apsimx to be edited (JSON)}

\item{src.dir}{directory containing the .apsimx file to be edited; defaults to the current working directory}

\item{wrt.dir}{should be used if the destination directory is different from the src.dir}

\item{rep.node}{replacement node as obtained by the \code{\link{get_apsimx_json}} function}

\item{rep.node.position}{position where the replacement node will be inserted, default is 1}

\item{new.core.position}{this by default will place the core simulation below the replacement node position. 
With this option, this can be modified.}

\item{edit.tag}{if the file is edited a different tag from the default \sQuote{-edited} can be used.}

\item{overwrite}{logical; if \code{TRUE} the old file is overwritten, a new file is written otherwise}

\item{verbose}{whether to print information about successful edit}

\item{root}{supply the node postion in the case of multiple simulations such as factorials.}
}
\value{
it does not return an R object but it writes an apsimx file to disk
}
\description{
Inserts a replacement node in a simple apsimx simulation file
}
\examples{
\dontrun{
tmp.dir <- tempdir()
wheat <- get_apsimx_json(model = "Wheat", wrt.dir = tmp.dir)
extd.dir <- system.file("extdata", package = "apsimx")
insert_replacement_node("Wheat.apsimx", 
                        src.dir = extd.dir, wrt.dir = tmp.dir,
                        rep.node = wheat)
}

}
