% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ssurgo_soil_profile.R
\name{get_ssurgo_soil_profile}
\alias{get_ssurgo_soil_profile}
\title{Retrieve soil profile data and convert it to an object of class \sQuote{soil_profile}}
\usage{
get_ssurgo_soil_profile(
  lonlat,
  shift = -1,
  nmapunit = 1,
  nsoil = 1,
  xout = NULL,
  soil.bottom = 200,
  method = c("constant", "linear"),
  nlayers = 10,
  check = TRUE,
  fix = FALSE,
  verbose = FALSE,
  xargs = NULL
)
}
\arguments{
\item{lonlat}{Longitude and latitude vector (e.g. c(-93, 42))}

\item{shift}{simple mechanism for creating an area of interest by displacing the point indicated in 
lonlat by some amount of distance (e.g. 300 - in meters)}

\item{nmapunit}{number of mapunits to select (see \code{\link{ssurgo2sp}})}

\item{nsoil}{number of soils to select (see \code{\link{ssurgo2sp}}). If the 
number of soils is negative or NA it will fetch all the soils in the mapunit}

\item{xout}{see \code{\link{ssurgo2sp}}}

\item{soil.bottom}{see \code{\link{ssurgo2sp}}}

\item{method}{interpolation method see \code{\link{ssurgo2sp}}}

\item{nlayers}{number for layer for the new soil profile}

\item{check}{whether to check for reasonable values using \code{\link{check_apsimx_soil_profile}}.
TRUE by default. If \sQuote{fix} is TRUE, it will be applied only after the fix attempt.}

\item{fix}{whether to fix compatibility between saturation and bulk density (default is FALSE).}

\item{verbose}{default FALSE. Whether to print messages.}

\item{xargs}{additional arguments passed to \code{\link{apsimx_soil_profile}} function.}
}
\value{
this function will always return a list. Each element of the list will
be an object of class \sQuote{soil_profile}
}
\description{
Generate a synthetic soil profile based on the information in SSURGO database
}
\details{
Data source is USDA-NRCS Soil Data Access. See package soilDB for more details
}
\examples{
\dontrun{
require(soilDB)
require(sp)
require(sf)
require(spData)
require(ggplot2)
## Soil inforation for a single point
sp <- get_ssurgo_soil_profile(lonlat = c(-93, 42))
## The initial attempt throws warnings, so better to use 'fix'
sp <- get_ssurgo_soil_profile(lonlat = c(-93, 42), fix = TRUE)
plot(sp[[1]])
plot(sp[[1]], property = "water")
## Add initial water
iwat <- initialwater_parms(Thickness = sp[[1]]$soil$Thickness,
                           InitialValues = sp[[1]]$soil$DUL * 0.8)
sp[[1]]$initialwater <- iwat
plot(sp[[1]], property = "initialwater")
}


}
