% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/munsell2rgb.R
\name{parseMunsell}
\alias{parseMunsell}
\title{Parse Munsell Color Notation}
\usage{
parseMunsell(munsellColor, convertColors = TRUE, ...)
}
\arguments{
\item{munsellColor}{character vector of Munsell colors (e.g. \code{c('10YR 3/4', '5YR 4/6')})}

\item{convertColors}{logical, convert colors to sRGB hex notation, sRGB coordinates, CIELAB coordinates}

\item{...}{additional arguments to \code{munsell2rgb}}
}
\value{
a \code{data.frame} object
}
\description{
Split Munsell color notation into "hue", "value", and "chroma", with optional conversion to sRGB hex notation, sRGB coordinates, and CIELAB coordinates. Conversion is performed by \code{munsell2rgb}.
}
\examples{

# just sRGB
parseMunsell("10YR 3/5", return_triplets = TRUE)

# sRGB + CIELAB (D65 illuminant)
parseMunsell("10YR 3/5", return_triplets = TRUE, returnLAB = TRUE)

# CIELAB only
parseMunsell("10YR 3/5", return_triplets = FALSE, returnLAB = TRUE)

}
