% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guessColumnNames.R
\name{guessHzAttrName}
\alias{guessHzAttrName}
\title{Guess Arbitrary Horizon Column Name}
\usage{
guessHzAttrName(x, attr, optional = NULL, verbose = TRUE)
}
\arguments{
\item{x}{A SoilProfileCollection}

\item{attr}{A regular expression containing required formative element of attribute name.}

\item{optional}{A character vector of regular expression(s) containing optional formative elements of attribute name.}

\item{verbose}{A boolean value for whether to produce message output about guesses.}
}
\value{
Character containing horizon attribute column name. Result is the first match in \code{horizonNames(x)} with the most required plus optional patterns matched.
}
\description{
Guess the horizon column name where possible/preferred formative elements are known. There is a preference for records where more optional requirements are met to handle cases where there will be many matches. For example, working with soil data one might have "low, RV and high" total clay, as well as clay fractions. One could distinguish between these different measurements using standard formative elements for column names from the database of interest. Result is the first match in \code{horizonNames(x)} with the most required plus optional patterns matched.

e.g. \code{guessHzAttrName(x, attr="clay", optional=c("total", "_r"))} matches (\code{claytotal_r == totalclay_r}) over (\code{clay_r == claytotal == totalclay}) over \code{clay}.
}
\examples{

# a has the required attr pattern, but none of the optional
a <- data.frame(id = 1, top = c(0,10), bottom=c(10,40),
                clay=c(18,19))
depths(a) <- id ~ top + bottom

guessHzAttrName(a, attr="clay", optional=c("total", "_r"))

# b has requried attr pattern, and one of the opional patterns
#   notice that it also contains "clay" but preferentially matches more optional patterns
b <- data.frame(id = 1, top = c(0,10), bottom=c(10,40),
                clay=c(0.18,0.19), clay_r=c(18,19))
depths(b) <- id ~ top + bottom

guessHzAttrName(b, attr="clay", optional=c("total", "_r"))

# c has total and _r (both optional) on either side of clay
# having all of the optional patterns plus required is best evidence, and first
# column containing that combination will be returned
c <- data.frame(id = 1, top = c(0,10), bottom=c(10,40),
                totalclay_r=c(18,19), claytotal_r=c(0.18,0.19))
depths(c) <- id ~ top + bottom

guessHzAttrName(c, attr="clay", optional=c("total", "_r"))

}
\seealso{
\code{\link{guessHzDesgnName}}, \code{\link{guessHzTexClName}}
}
\author{
Andrew G. Brown
}
