## BOUNDS TEST FUNCTION -----------------------
# If you use this function, you have adopted the dynamac::pssbounds() 
# function. Consider acknowledging the package authors using citation('dynamac')
dynamac_pkg_bounds_test <- function (obs, fstat, tstat = NULL, case, k) 
{
  cases <- seq(1, 5, 1)
  cases.roman <- c("I", "II", "III", "IV", "V")
  fnote <- tnote <- NULL
  if ((case %in% cases.roman) == TRUE) {
    if (case == "I") {
      case <- 1
    }
    else if (case == "II") {
      case <- 2
    }
    else if (case == "III") {
      case <- 3
    }
    else if (case == "IV") {
      case <- 4
    }
    else if (case == "V") {
      case <- 5
    }
  }
  if ((case %in% cases) == FALSE) {
    stop("Case must be 1, 2, 3, 4, or 5.")
  }
  if (obs <= 30) {
    if (case == 1) {
      fnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(4.025, 4.025, 5.07, 5.07, 7.595, 
                       7.595, 3.303, 3.797, 4.09, 4.663, 6.027, 6.76, 
                       2.915, 3.695, 3.538, 4.428, 5.155, 6.265, 2.676, 
                       3.586, 3.272, 4.306, 4.614, 5.966, 2.525, 3.56, 
                       3.058, 4.223, 4.28, 5.84, 2.407, 3.517, 2.91, 
                       4.193, 4.134, 5.761, 2.334, 3.515, 2.794, 4.148, 
                       3.976, 5.691, 2.277, 3.498, 2.73, 4.163, 3.864, 
                       5.694), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.84, 6.84, 8.77, 8.77, 13.68, 
                       13.68, 4.29, 5.08, 5.395, 6.35, 8.17, 9.285, 
                       3.437, 4.47, 4.267, 5.473, 6.183, 7.873, 3.008, 
                       4.15, 3.71, 5.018, 5.333, 7.063, 2.752, 3.994, 
                       3.354, 4.774, 4.768, 6.67, 2.578, 3.858, 3.125, 
                       4.608, 4.537, 6.37, 2.457, 3.797, 2.97, 4.499, 
                       4.27, 6.211, 2.384, 3.728, 2.875, 4.445, 4.104, 
                       6.151), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.785, 5.785, 7.04, 7.04, 10.2, 
                       10.2, 4.427, 4.957, 5.377, 5.963, 7.593, 8.35, 
                       3.77, 4.535, 4.535, 5.415, 6.428, 7.505, 3.378, 
                       4.274, 4.048, 5.09, 5.666, 6.988, 3.097, 4.118, 
                       3.715, 4.878, 5.205, 6.64, 2.907, 4.01, 3.504, 
                       4.743, 4.85, 6.473, 2.781, 3.941, 3.326, 4.653, 
                       4.689, 6.358, 2.681, 3.887, 3.194, 4.604, 4.49, 
                       6.328), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.34, 10.34, 12.74, 12.74, 18.56, 
                       18.56, 6.01, 6.78, 7.36, 8.265, 10.605, 11.65, 
                       4.577, 5.6, 5.55, 6.747, 7.977, 9.413, 3.868, 
                       4.965, 4.683, 5.98, 6.643, 8.313, 3.43, 4.624, 
                       4.154, 5.54, 5.856, 7.578, 3.157, 4.412, 3.818, 
                       5.253, 5.347, 7.242, 2.977, 4.26, 3.576, 5.065, 
                       5.046, 6.93, 2.483, 4.16, 3.394, 4.939, 4.779, 
                       6.821), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 35) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 11.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.98, 3.98, 4.945, 4.945, 7.35, 
                       7.35, 3.223, 3.757, 3.957, 4.53, 5.763, 6.48, 
                       2.845, 3.623, 3.478, 4.335, 4.948, 6.028, 2.618, 
                       3.532, 3.164, 4.194, 4.428, 5.816, 2.46, 3.46, 
                       2.947, 4.088, 4.093, 5.532, 2.331, 3.417, 2.804, 
                       4.013, 3.9, 5.419, 2.254, 3.388, 2.685, 3.96, 
                       3.713, 5.326, 2.196, 3.37, 2.597, 3.907, 3.599, 
                       5.23), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.81, 6.81, 8.64, 8.64, 13.29, 
                       13.29, 4.225, 5.05, 5.29, 6.175, 7.87, 8.96, 
                       3.393, 4.41, 4.183, 5.333, 6.14, 7.607, 2.958, 
                       4.1, 3.615, 4.913, 5.198, 6.845, 2.696, 3.898, 
                       3.276, 4.63, 4.59, 6.368, 2.508, 3.763, 3.037, 
                       4.443, 4.257, 6.04, 2.387, 3.671, 2.864, 4.324, 
                       4.016, 5.797, 2.3, 3.606, 2.753, 4.209, 3.841, 
                       5.686), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.69, 5.69, 6.9, 6.9, 9.975, 9.975, 
                       4.38, 4.867, 5.233, 5.777, 7.477, 8.213, 3.698, 
                       4.42, 4.433, 5.245, 6.328, 7.408, 3.29, 4.176, 
                       3.936, 4.918, 5.654, 6.926, 3.035, 3.997, 3.578, 
                       4.668, 5.147, 6.617, 2.831, 3.879, 3.353, 4.5, 
                       4.849, 6.511, 2.685, 3.785, 3.174, 4.383, 4.629, 
                       5.698, 2.578, 3.71, 3.057, 4.319, 4.489, 5.064), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.24, 10.24, 12.58, 12.58, 18.02, 
                       18.02, 5.95, 6.68, 7.21, 8.055, 10.365, 11.295, 
                       4.517, 5.48, 5.457, 6.57, 7.643, 9.063, 3.8, 
                       4.888, 4.568, 5.795, 6.38, 7.73, 3.374, 4.512, 
                       4.036, 5.304, 5.604, 7.172, 3.087, 4.277, 3.673, 
                       5.002, 5.095, 6.77, 2.879, 4.114, 3.426, 4.79, 
                       4.704, 6.537, 2.729, 3.985, 3.251, 4.64, 4.459, 
                       6.206), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 40) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.955, 3.955, 4.96, 4.96, 7.22, 
                       7.22, 3.21, 3.73, 3.937, 4.523, 5.593, 6.333, 
                       2.835, 3.585, 3.435, 4.26, 4.77, 5.855, 2.592, 
                       3.454, 3.1, 4.088, 4.31, 5.544, 2.427, 3.395, 
                       2.893, 4, 3.967, 5.455, 2.306, 3.353, 2.734, 
                       3.92, 3.657, 5.256, 2.218, 3.314, 2.618, 3.863, 
                       3.505, 5.121, 2.152, 3.296, 2.523, 3.829, 3.402, 
                       5.031), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.76, 6.76, 8.57, 8.57, 13.07, 
                       13.07, 4.235, 5, 5.26, 6.16, 7.625, 8.825, 3.373, 
                       4.377, 4.133, 5.26, 5.893, 7.337, 2.933, 4.02, 
                       3.548, 4.803, 5.018, 6.61, 2.66, 3.838, 3.202, 
                       4.544, 4.428, 6.25, 2.483, 3.708, 2.962, 4.338, 
                       4.045, 5.898, 2.353, 3.599, 2.797, 4.211, 3.8, 
                       5.643, 2.26, 3.534, 2.676, 4.13, 3.644, 5.464), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.68, 5.68, 6.87, 6.87, 9.575, 
                       9.575, 4.343, 4.823, 5.18, 5.733, 7.207, 7.86, 
                       3.663, 4.378, 4.36, 5.138, 5.98, 6.973, 3.264, 
                       4.094, 3.85, 4.782, 5.258, 6.526, 2.985, 3.918, 
                       3.512, 4.587, 4.763, 6.2, 2.781, 3.813, 3.257, 
                       4.431, 4.427, 5.837, 2.634, 3.719, 3.07, 4.309, 
                       4.154, 5.699, 2.517, 3.65, 2.933, 4.224, 3.971, 
                       5.486), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.16, 10.16, 12.51, 12.51, 17.91, 
                       17.91, 5.915, 6.63, 7.135, 7.98, 10.15, 11.23, 
                       4.477, 5.42, 5.387, 6.437, 7.527, 8.803, 3.76, 
                       4.795, 4.51, 5.643, 6.238, 7.74, 3.334, 4.438, 
                       3.958, 5.226, 5.376, 7.092, 3.032, 4.213, 3.577, 
                       4.923, 4.885, 6.55, 2.831, 4.04, 3.327, 4.7, 
                       4.527, 6.263, 2.668, 3.92, 3.121, 4.564, 4.31, 
                       5.965), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 45) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.95, 3.95, 4.895, 4.895, 7.265, 
                       7.265, 3.19, 3.73, 3.877, 4.46, 5.607, 6.193, 
                       2.788, 3.54, 3.368, 4.203, 4.8, 5.725, 2.56, 
                       3.428, 3.078, 4.022, 4.27, 5.412, 2.402, 3.345, 
                       2.85, 3.905, 3.892, 5.173, 2.276, 3.297, 2.694, 
                       3.829, 3.674, 5.019, 2.188, 3.254, 2.591, 3.766, 
                       3.54, 4.931, 2.131, 3.223, 2.504, 3.723, 3.383, 
                       4.832), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.76, 6.76, 8.59, 8.59, 12.93, 
                       12.93, 4.225, 5.02, 5.235, 6.135, 7.74, 8.65, 
                       3.33, 4.347, 4.083, 5.207, 5.92, 7.197, 2.893, 
                       3.983, 3.535, 4.733, 4.983, 6.423, 2.638, 3.772, 
                       3.178, 4.45, 4.394, 5.914, 2.458, 3.647, 2.922, 
                       4.268, 4.03, 5.598, 2.327, 3.541, 2.764, 4.123, 
                       3.79, 5.411, 2.238, 3.461, 2.643, 4.004, 3.595, 
                       5.225), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.625, 5.625, 6.75, 6.75, 9.555, 
                       9.555, 4.3, 4.78, 5.13, 5.68, 7.133, 7.82, 3.625, 
                       4.33, 4.335, 5.078, 5.878, 6.87, 3.226, 4.054, 
                       3.822, 4.714, 5.15, 6.28, 2.95, 3.862, 3.47, 
                       4.47, 4.628, 5.865, 2.75, 3.739, 3.211, 4.309, 
                       4.251, 5.596, 2.606, 3.644, 3.025, 4.198, 3.998, 
                       5.463, 2.484, 3.57, 2.899, 4.087, 3.829, 5.313), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.15, 10.15, 12.4, 12.4, 17.5, 
                       17.5, 5.88, 6.64, 7.08, 7.91, 9.89, 10.965, 
                       4.437, 5.377, 5.36, 6.373, 7.317, 8.72, 3.74, 
                       4.78, 4.45, 5.56, 6.053, 7.458, 3.298, 4.378, 
                       3.89, 5.104, 5.224, 6.696, 3.012, 4.147, 3.532, 
                       4.8, 4.715, 6.293, 2.796, 3.97, 3.267, 4.584, 
                       4.364, 6.006, 2.635, 3.838, 3.091, 4.413, 4.109, 
                       5.785), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 50) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.935, 3.935, 4.815, 4.815, 7.065, 
                       7.065, 3.177, 3.653, 3.86, 4.44, 5.503, 6.24, 
                       2.788, 3.513, 3.368, 4.178, 4.695, 5.758, 2.538, 
                       3.398, 3.048, 4.002, 4.188, 5.328, 2.372, 3.32, 
                       2.823, 3.872, 3.845, 5.15, 2.259, 3.264, 2.67, 
                       3.781, 3.593, 4.981, 2.17, 3.22, 2.55, 3.708, 
                       3.424, 4.88, 2.099, 3.181, 2.457, 3.65, 3.282, 
                       4.73), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.74, 6.74, 8.51, 8.51, 12.73, 
                       12.73, 4.19, 4.94, 5.22, 6.07, 7.56, 8.685, 
                       3.333, 4.313, 4.07, 5.19, 5.817, 7.303, 2.873, 
                       3.973, 3.5, 4.7, 4.865, 6.36, 2.614, 3.746, 
                       3.136, 4.416, 4.306, 5.874, 2.435, 3.6, 2.9, 
                       4.218, 3.955, 5.583, 2.309, 3.507, 2.726, 4.057, 
                       3.656, 5.331, 2.205, 3.421, 2.593, 3.941, 3.498, 
                       5.149), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.57, 5.57, 6.685, 6.685, 9.32, 
                       9.32, 4.23, 4.74, 5.043, 5.607, 7.017, 7.727, 
                       3.573, 4.288, 4.225, 5.03, 5.805, 6.79, 3.174, 
                       4.004, 3.73, 4.666, 5.05, 6.182, 2.905, 3.822, 
                       3.383, 4.432, 4.557, 5.793, 2.703, 3.697, 3.149, 
                       4.293, 4.214, 5.52, 2.55, 3.609, 2.975, 4.143, 
                       3.983, 5.345, 2.44, 3.523, 2.832, 4.012, 3.762, 
                       5.172), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.02, 10.02, 12.17, 12.17, 17.53, 
                       17.53, 5.78, 6.54, 6.985, 7.86, 9.895, 10.965, 
                       4.38, 5.35, 5.247, 6.303, 7.337, 8.643, 3.673, 
                       4.715, 4.368, 5.545, 5.995, 7.335, 3.24, 4.35, 
                       3.834, 5.064, 5.184, 6.684, 2.95, 4.11, 3.48, 
                       4.782, 4.672, 6.232, 2.75, 3.944, 3.229, 4.536, 
                       4.31, 5.881, 2.59, 3.789, 3.039, 4.339, 4.055, 
                       5.64), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 55) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.9, 3.9, 4.795, 4.795, 6.965, 
                       6.965, 3.143, 3.67, 3.79, 4.393, 5.377, 6.047, 
                       2.748, 3.495, 3.303, 4.1, 4.61, 5.563, 2.508, 
                       3.356, 2.982, 3.942, 4.118, 5.2, 2.345, 3.28, 
                       2.763, 3.813, 3.738, 4.947, 2.226, 3.241, 2.617, 
                       3.743, 3.543, 4.839, 2.139, 3.204, 2.49, 3.658, 
                       3.33, 4.708, 2.069, 3.148, 2.414, 3.608, 3.194, 
                       4.562), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.7, 6.7, 8.39, 8.39, 12.7, 12.7, 
                       4.155, 4.925, 5.125, 6.045, 7.435, 8.46, 3.28, 
                       4.273, 3.987, 5.09, 5.707, 6.977, 2.843, 3.92, 
                       3.408, 4.623, 4.828, 6.195, 2.578, 3.71, 3.068, 
                       4.334, 4.244, 5.726, 2.393, 3.583, 2.848, 4.16, 
                       3.928, 5.408, 2.27, 3.486, 2.676, 3.999, 3.636, 
                       5.169, 2.181, 3.398, 2.556, 3.904, 3.424, 4.989), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.57, 5.57, 6.66, 6.66, 9.3, 9.3, 
                       4.23, 4.73, 5.013, 5.547, 6.893, 7.537, 3.553, 
                       4.238, 4.183, 4.955, 5.678, 6.578, 3.132, 3.956, 
                       3.692, 4.582, 4.99, 6.018, 2.868, 3.782, 3.358, 
                       4.365, 4.455, 5.615, 2.674, 3.659, 3.131, 4.206, 
                       4.111, 5.329, 2.538, 3.56, 2.946, 4.065, 3.87, 
                       5.171, 2.42, 3.481, 2.791, 3.95, 3.643, 5.021), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.11, 10.11, 12.17, 12.17, 17.48, 
                       17.48, 5.8, 6.515, 6.93, 7.785, 9.8, 10.675, 
                       4.37, 5.303, 5.19, 6.223, 7.227, 8.34, 3.64, 
                       4.67, 4.313, 5.425, 5.955, 7.225, 3.21, 4.294, 
                       3.794, 4.986, 5.108, 6.494, 2.927, 4.068, 3.442, 
                       4.69, 4.608, 5.977, 2.724, 3.893, 3.197, 4.46, 
                       4.23, 5.713, 2.573, 3.76, 2.989, 4.271, 3.955, 
                       5.474), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 60) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.88, 3.88, 4.78, 4.78, 6.96, 6.96, 
                       3.127, 3.65, 3.803, 4.363, 5.383, 6.033, 2.738, 
                       3.465, 3.288, 4.07, 4.558, 5.59, 2.496, 3.346, 
                       2.962, 3.91, 4.068, 5.25, 2.323, 3.273, 2.743, 
                       3.792, 3.71, 4.965, 2.204, 3.21, 2.589, 3.683, 
                       3.451, 4.764, 2.114, 3.153, 2.456, 3.598, 3.293, 
                       4.615, 2.044, 3.104, 2.373, 3.54, 3.129, 4.507), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.7, 6.7, 8.46, 8.46, 12.49, 12.49, 
                       4.145, 4.95, 5.125, 6, 7.4, 8.51, 3.27, 4.26, 
                       4, 5.057, 5.697, 6.987, 2.838, 3.923, 3.415, 
                       4.615, 4.748, 6.188, 2.568, 3.712, 3.062, 4.314, 
                       4.176, 5.676, 2.385, 3.565, 2.817, 4.097, 3.783, 
                       5.338, 2.253, 3.436, 2.643, 3.939, 3.531, 5.081, 
                       2.155, 3.353, 2.513, 3.823, 3.346, 4.895), ncol = 6, 
                     byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.555, 5.555, 6.63, 6.63, 9.245, 
                       9.245, 4.203, 4.693, 4.98, 5.527, 6.78, 7.377, 
                       3.54, 4.235, 4.18, 4.938, 5.62, 6.503, 3.13, 
                       3.968, 3.684, 4.584, 4.928, 5.95, 2.852, 3.773, 
                       3.323, 4.333, 4.412, 5.545, 2.653, 3.637, 3.086, 
                       4.154, 4.013, 5.269, 2.51, 3.519, 2.9, 3.999, 
                       3.775, 5.086, 2.392, 3.444, 2.756, 3.892, 3.584, 
                       4.922), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.03, 10.03, 12.2, 12.2, 17.02, 
                       17.02, 5.765, 6.5, 6.905, 7.735, 9.585, 10.42, 
                       4.35, 5.283, 5.19, 6.2, 7.057, 8.243, 3.645, 
                       4.678, 4.298, 5.445, 5.835, 7.108, 3.2, 4.31, 
                       3.772, 4.956, 5.066, 6.394, 2.912, 4.047, 3.407, 
                       4.632, 4.505, 5.92, 2.709, 3.856, 3.137, 4.393, 
                       4.117, 5.597, 2.551, 3.716, 2.956, 4.23, 3.87, 
                       5.338), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 65) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.88, 3.88, 4.78, 4.78, 6.825, 
                       6.825, 3.143, 3.623, 3.787, 4.343, 5.35, 6.017, 
                       2.74, 3.455, 3.285, 4.07, 4.538, 5.475, 2.492, 
                       3.35, 2.976, 3.896, 4.056, 5.158, 2.335, 3.252, 
                       2.75, 3.755, 3.725, 4.94, 2.209, 3.201, 2.596, 
                       3.677, 3.43, 4.721, 2.12, 3.145, 2.473, 3.583, 
                       3.225, 4.571, 2.043, 3.094, 2.373, 3.519, 3.092, 
                       4.478), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.74, 6.74, 8.49, 8.49, 12.4, 12.4, 
                       4.175, 4.93, 5.13, 5.98, 7.32, 8.435, 3.3, 4.25, 
                       4.01, 5.08, 5.583, 6.853, 2.843, 3.923, 3.435, 
                       4.583, 4.69, 6.143, 2.574, 3.682, 3.068, 4.274, 
                       4.188, 5.694, 2.397, 3.543, 2.835, 4.09, 3.783, 
                       5.3, 2.256, 3.43, 2.647, 3.921, 3.501, 5.051, 
                       2.156, 3.334, 2.525, 3.808, 3.31, 4.871), ncol = 6, 
                     byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.51, 5.51, 6.55, 6.55, 8.96, 8.96, 
                       4.187, 4.66, 4.95, 5.467, 6.707, 7.36, 3.535, 
                       4.208, 4.123, 4.903, 5.545, 6.453, 3.122, 3.942, 
                       3.626, 4.538, 4.848, 5.842, 2.848, 3.743, 3.3, 
                       4.28, 4.347, 5.552, 2.647, 3.603, 3.063, 4.123, 
                       4.02, 5.263, 2.499, 3.49, 2.88, 3.978, 3.758, 
                       5.04, 2.379, 3.406, 2.73, 3.879, 3.557, 4.902), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(9.97, 9.97, 11.96, 11.96, 16.85, 
                       16.85, 5.755, 6.47, 6.89, 7.66, 9.475, 10.515, 
                       4.353, 5.257, 5.137, 6.173, 7.013, 8.23, 3.638, 
                       4.643, 4.268, 5.415, 5.795, 7.053, 3.196, 4.262, 
                       3.732, 4.92, 4.974, 6.378, 2.897, 4.022, 3.372, 
                       4.613, 4.482, 5.923, 2.69, 3.83, 3.137, 4.363, 
                       4.111, 5.586, 2.531, 3.685, 2.924, 4.206, 3.835, 
                       5.339), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 70) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.875, 3.875, 4.75, 4.75, 6.74, 
                       6.74, 3.12, 3.623, 3.78, 4.327, 5.157, 5.957, 
                       2.73, 3.445, 3.243, 4.043, 4.398, 5.463, 2.482, 
                       3.31, 2.924, 3.86, 3.916, 5.088, 2.32, 3.232, 
                       2.725, 3.718, 3.608, 4.86, 2.193, 3.161, 2.564, 
                       3.65, 3.373, 4.717, 2.1, 3.121, 2.451, 3.559, 
                       3.18, 4.596, 2.024, 3.079, 2.351, 3.498, 3.034, 
                       4.426), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.67, 6.67, 8.37, 8.37, 12.24, 
                       12.24, 4.125, 4.88, 5.055, 5.915, 7.17, 8.405, 
                       3.25, 4.237, 3.947, 5.02, 5.487, 6.88, 2.818, 
                       3.88, 3.37, 4.545, 4.635, 6.055, 2.552, 3.648, 
                       3.022, 4.256, 4.098, 5.57, 2.363, 3.51, 2.788, 
                       4.073, 3.747, 5.285, 2.233, 3.407, 2.629, 3.906, 
                       3.436, 5.044, 2.138, 3.325, 2.494, 3.786, 3.261, 
                       4.821), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, 2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.53, 5.53, 6.53, 6.53, 8.89, 8.89, 
                       4.173, 4.647, 4.93, 5.457, 6.577, 7.313, 3.505, 
                       4.198, 4.1, 4.9, 5.448, 6.435, 3.098, 3.92, 
                       3.6, 4.512, 4.76, 5.798, 2.832, 3.738, 3.272, 
                       4.272, 4.293, 5.46, 2.631, 3.589, 3.043, 4.1, 
                       3.966, 5.234, 2.485, 3.473, 2.86, 3.951, 3.72, 
                       5.004, 2.363, 3.394, 2.711, 3.842, 3.509, 4.808), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.02, 10.02, 12, 12, 16.66, 16.66, 
                       5.765, 6.455, 6.86, 7.645, 9.37, 10.32, 4.33, 
                       5.243, 5.11, 6.19, 6.873, 8.163, 3.615, 4.635, 
                       4.235, 5.363, 5.663, 6.953, 3.182, 4.258, 3.72, 
                       4.904, 4.922, 6.328, 2.893, 4.008, 3.368, 4.59, 
                       4.428, 5.898, 2.683, 3.807, 3.107, 4.343, 4.07, 
                       5.534, 2.519, 3.669, 2.913, 4.168, 3.774, 5.248), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 75) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.895, 3.895, 4.76, 4.76, 6.915, 
                       6.915, 3.133, 3.597, 3.777, 4.32, 5.26, 5.957, 
                       2.725, 3.455, 3.253, 4.065, 4.458, 5.41, 2.482, 
                       3.334, 2.946, 3.862, 4.048, 5.092, 2.313, 3.228, 
                       2.725, 3.718, 3.687, 4.842, 2.196, 3.166, 2.574, 
                       3.641, 3.427, 4.62, 2.103, 3.111, 2.449, 3.55, 
                       3.219, 4.526, 2.023, 3.068, 2.36, 3.478, 3.057, 
                       4.413), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.72, 6.72, 8.42, 8.42, 12.54, 
                       12.54, 4.15, 4.885, 5.14, 5.92, 7.225, 8.3, 
                       3.277, 4.243, 3.983, 5.06, 5.513, 6.86, 2.838, 
                       3.898, 3.408, 4.55, 4.725, 6.08, 2.558, 3.654, 
                       3.042, 4.244, 4.168, 5.548, 2.38, 3.515, 2.802, 
                       4.065, 3.772, 5.213, 2.244, 3.397, 2.637, 3.9, 
                       3.496, 4.966, 2.134, 3.313, 2.503, 3.768, 3.266, 
                       4.801), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.53, 5.53, 6.58, 6.58, 8.905, 
                       8.905, 4.193, 4.647, 4.937, 5.443, 6.613, 7.253, 
                       3.505, 4.213, 4.12, 4.855, 5.505, 6.298, 3.11, 
                       3.9, 3.624, 4.488, 4.808, 5.786, 2.832, 3.717, 
                       3.298, 4.26, 4.3, 5.377, 2.636, 3.579, 3.054, 
                       4.079, 3.984, 5.153, 2.486, 3.469, 2.874, 3.914, 
                       3.728, 4.954, 2.372, 3.37, 2.718, 3.807, 3.511, 
                       4.789), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(10.03, 10.03, 12.08, 12.08, 16.61, 
                       16.61, 5.765, 6.47, 6.88, 7.675, 9.325, 10.325, 
                       4.323, 5.273, 5.14, 6.153, 6.93, 8.027, 3.618, 
                       4.63, 4.253, 5.333, 5.698, 6.97, 3.182, 4.248, 
                       3.724, 4.88, 4.932, 6.224, 2.89, 3.993, 3.382, 
                       4.567, 4.393, 5.788, 2.681, 3.8, 3.111, 4.31, 
                       4.06, 5.459, 2.53, 3.648, 2.915, 4.143, 3.768, 
                       5.229), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else if (obs <= 80) {
    if (case == 1) {
      fnote <- "Small-sample critical values are not provided for Case I. Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case I. Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.87, 3.87, 4.725, 4.725, 6.695, 
                       6.695, 3.113, 3.61, 3.74, 4.303, 5.157, 5.917, 
                       2.713, 3.453, 3.235, 4.053, 4.358, 5.393, 2.474, 
                       3.312, 2.92, 3.838, 3.908, 5.004, 2.303, 3.22, 
                       2.688, 3.698, 3.602, 4.787, 2.303, 3.154, 2.55, 
                       3.606, 3.351, 4.587, 2.088, 3.103, 2.431, 3.518, 
                       3.173, 4.485, 2.017, 3.052, 2.336, 3.458, 3.021, 
                       4.35), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.72, 6.72, 8.4, 8.4, 12.12, 12.12, 
                       4.135, 4.895, 5.06, 5.93, 7.095, 8.26, 3.26, 
                       4.247, 3.94, 5.043, 5.407, 6.783, 2.823, 3.885, 
                       3.363, 4.515, 4.568, 5.96, 2.548, 3.644, 3.01, 
                       4.216, 4.096, 5.512, 2.355, 3.5, 2.787, 4.015, 
                       3.725, 5.163, 2.236, 3.381, 2.627, 3.864, 3.457, 
                       4.943, 2.129, 3.289, 2.476, 3.746, 3.233, 4.76), 
                     ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case III. Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(3.87, 3.87, 4.725, 4.725, 6.695, 
                       6.695, 3.113, 3.61, 3.74, 4.303, 5.157, 5.917, 
                       2.713, 3.453, 3.235, 4.053, 4.358, 5.393, 2.474, 
                       3.312, 2.92, 3.838, 3.908, 5.004, 2.303, 3.22, 
                       2.688, 3.698, 3.602, 4.787, 2.18, 3.154, 2.55, 
                       3.606, 3.351, 4.587, 2.088, 3.103, 2.431, 3.518, 
                       3.173, 4.485, 2.017, 3.052, 2.336, 3.458, 3.021, 
                       4.35), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(9.96, 9.96, 12.06, 12.06, 16.6, 
                       16.6, 5.725, 6.45, 6.82, 7.67, 9.17, 10.24, 
                       4.307, 5.223, 5.067, 6.103, 6.73, 8.053, 3.588, 
                       4.605, 4.203, 5.32, 5.62, 6.908, 3.16, 4.23, 
                       3.678, 4.84, 4.89, 6.164, 2.867, 3.975, 3.335, 
                       4.535, 4.375, 5.703, 2.657, 3.776, 3.077, 4.284, 
                       4, 5.397, 2.504, 3.631, 2.885, 4.111, 3.728, 
                       5.16), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Small-sample critical values not provided for Case V. Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  else {
    if (case == 1) {
      fnote <- "Asymptotic critical values used."
      fmat <- matrix(c(3, 3, 4.2, 4.2, 7.17, 7.17, 2.44, 
                       3.28, 3.15, 4.11, 4.81, 6.02, 2.17, 3.19, 2.72, 
                       3.83, 3.88, 5.3, 2.01, 3.1, 2.45, 3.63, 3.42, 
                       4.84, 1.9, 3.01, 2.26, 3.48, 3.07, 4.44, 1.81, 
                       2.93, 2.14, 3.34, 2.82, 4.21, 1.75, 2.87, 2.04, 
                       3.24, 2.66, 4.05, 1.7, 2.83, 1.97, 3.18, 2.54, 
                       3.91, 1.66, 2.79, 1.91, 3.11, 2.45, 3.79, 1.63, 
                       2.75, 1.86, 3.05, 2.34, 3.68, 1.6, 2.72, 1.82, 
                       2.99, 2.26, 3.6), ncol = 6, byrow = TRUE)
      if (!is.null(tstat)) {
        tnote <- "Asymptotic critical values used."
        tmat <- matrix(c(-1.62, -1.62, -1.95, -1.95, 
                         -2.58, -2.58, -1.62, -2.28, -1.95, -2.6, -2.58, 
                         -3.22, -1.62, -2.68, -1.95, -3.02, -2.58, 
                         -3.66, -1.62, -3, -1.95, -3.33, -2.58, -3.97, 
                         -1.62, -3.26, -1.95, -3.6, -2.58, -4.23, -1.62, 
                         -3.49, -1.95, -3.83, -2.58, -4.44, -1.62, 
                         -3.7, -1.95, -4.04, -2.58, -4.67, -1.62, -3.9, 
                         -1.95, -4.23, -2.58, -4.88, -1.62, -4.09, 
                         -1.95, -4.43, -2.58, -5.07, -1.62, -4.26, 
                         -1.95, -4.61, -2.58, -5.25, -1.62, -4.42, 
                         -1.95, -4.76, -2.58, -5.44), ncol = 6, byrow = TRUE)
      }
    }
    else if (case == 2) {
      fmat <- matrix(c(3.8, 3.8, 4.6, 4.6, 6.44, 6.44, 
                       3.02, 3.51, 3.62, 4.16, 4.94, 5.58, 2.63, 3.35, 
                       3.1, 3.87, 4.13, 5, 2.37, 3.2, 2.79, 3.67, 3.65, 
                       4.66, 2.2, 3.09, 2.56, 3.49, 3.29, 4.37, 2.08, 
                       3, 2.39, 3.38, 3.06, 4.15, 1.99, 2.94, 2.27, 
                       3.28, 2.88, 3.99, 1.92, 2.89, 2.17, 3.21, 2.73, 
                       3.9, 1.85, 2.85, 2.11, 3.15, 2.62, 3.77, 1.8, 
                       2.8, 2.04, 3.08, 2.5, 3.68, 1.76, 2.77, 1.98, 
                       3.04, 2.41, 3.61), ncol = 6, byrow = TRUE)
      fnote <- "Asymptotic critical values used."
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case II."
      }
    }
    else if (case == 3) {
      fmat <- matrix(c(6.58, 6.58, 8.21, 8.21, 11.79, 
                       11.79, 4.04, 4.78, 4.94, 5.73, 6.84, 7.84, 3.17, 
                       4.14, 3.79, 4.85, 5.15, 6.36, 2.72, 3.77, 3.23, 
                       4.35, 4.29, 5.61, 2.45, 3.52, 2.86, 4.01, 3.74, 
                       5.06, 2.26, 3.35, 2.62, 3.79, 3.41, 4.68, 2.12, 
                       3.23, 2.45, 3.61, 3.15, 4.43, 2.03, 3.13, 2.32, 
                       3.5, 2.96, 4.26, 1.95, 3.06, 2.22, 3.39, 2.79, 
                       4.1, 1.88, 2.99, 2.14, 3.3, 2.65, 3.97, 1.83, 
                       2.94, 2.06, 3.24, 2.54, 3.86), ncol = 6, byrow = TRUE)
      fnote <- "Asymptotic critical values used."
      if (!is.null(tstat)) {
        tnote <- "Asymptotic critical values used."
        tmat <- matrix(c(-2.57, -2.57, -2.86, -2.86, 
                         -3.43, -3.43, -2.57, -2.91, -2.86, -3.22, 
                         -3.43, -3.82, -2.57, -3.21, -2.86, -3.53, 
                         -3.43, -4.1, -2.57, -3.46, -2.86, -3.78, -3.43, 
                         -4.37, -2.57, -3.66, -2.86, -3.99, -3.43, 
                         -4.6, -2.57, -3.86, -2.86, -4.19, -3.43, -4.79, 
                         -2.57, -4.04, -2.86, -4.38, -3.43, -4.99, 
                         -2.57, -4.23, -2.86, -4.57, -3.43, -5.19, 
                         -2.57, -4.4, -2.86, -4.72, -3.43, -5.37, -2.57, 
                         -4.56, -2.86, -4.88, -3.42, -5.54, -2.57, 
                         -4.69, -2.86, -5.03, -3.43, -5.68), ncol = 6, 
                       byrow = TRUE)
      }
    }
    else if (case == 4) {
      fmat <- matrix(c(5.37, 5.37, 6.29, 6.29, 8.26, 8.26, 
                       4.05, 4.49, 4.68, 5.15, 6.1, 6.73, 3.38, 4.02, 
                       3.88, 4.61, 4.99, 5.85, 2.97, 3.74, 3.38, 4.23, 
                       4.3, 5.23, 2.68, 3.53, 3.05, 3.97, 3.81, 4.92, 
                       2.49, 3.38, 2.81, 3.76, 3.5, 4.63, 2.33, 3.25, 
                       2.63, 3.62, 3.27, 4.39, 2.22, 3.17, 2.5, 3.5, 
                       3.07, 4.23, 2.13, 3.09, 2.38, 3.41, 2.93, 4.06, 
                       2.05, 3.02, 2.3, 3.33, 2.79, 3.93, 1.98, 2.97, 
                       2.21, 3.25, 2.68, 3.84), ncol = 6, byrow = TRUE)
      fnote <- "Asymptotic critical values used."
      if (!is.null(tstat)) {
        tnote <- "Critical values do not currently exist for Case IV."
      }
    }
    else {
      fmat <- matrix(c(9.81, 9.81, 11.64, 11.64, 15.73, 
                       15.73, 5.59, 6.26, 6.56, 7.3, 8.74, 9.63, 4.19, 
                       5.06, 4.87, 5.85, 6.34, 7.52, 3.47, 4.45, 4.01, 
                       5.07, 5.17, 6.36, 3.03, 4.06, 3.47, 4.57, 4.4, 
                       5.72, 2.75, 3.79, 3.12, 4.25, 3.93, 5.23, 2.53, 
                       3.59, 2.87, 4, 3.6, 4.9, 2.38, 3.45, 2.69, 3.83, 
                       3.34, 4.63, 2.26, 3.34, 2.55, 3.68, 3.15, 4.43, 
                       2.16, 3.24, 2.43, 3.56, 2.97, 4.24, 2.07, 3.16, 
                       2.33, 3.46, 2.84, 4.1), ncol = 6, byrow = TRUE)
      fnote <- "Asymptotic critical values used."
      if (!is.null(tstat)) {
        tnote <- "Asymptotic critical values used."
        tmat <- matrix(c(-3.13, -3.13, -3.41, -3.41, 
                         -3.96, -3.97, -3.13, -3.4, -3.41, -3.69, -3.96, 
                         -4.26, -3.13, -3.63, -3.41, -3.95, -3.96, 
                         -4.53, -3.13, -3.84, -3.41, -4.16, -3.96, 
                         -4.73, -3.13, -4.04, -3.41, -4.36, -3.96, 
                         -4.96, -3.13, -4.21, -3.41, -4.52, -3.96, 
                         -5.13, -3.13, -4.37, -3.41, -4.69, -3.96, 
                         -5.31, -3.13, -4.53, -3.41, -4.85, -3.96, 
                         -5.49, -3.13, -4.68, -3.41, -5.01, -3.96, 
                         -5.65, -3.13, -4.82, -3.41, -5.15, -3.96, 
                         -5.79, -3.13, -4.96, -3.41, -5.29, -3.96, 
                         -5.94), ncol = 6, byrow = TRUE)
      }
    }
  }
  f_10_1 <- f_10_1 <- f_05_1 <- f_05_1 <- f_01_1 <- f_01_1 <- NULL
  if (obs <= 80) {
    if (k < 7) {
      k2 <- k + 1
      f_10_0 <- fmat[k2, 1]
      f_10_1 <- fmat[k2, 2]
      f_05_0 <- fmat[k2, 3]
      f_05_1 <- fmat[k2, 4]
      f_01_0 <- fmat[k2, 5]
      f_01_1 <- fmat[k2, 6]
    }
    else {
      f_10_0 <- fmat[8, 1]
      f_10_1 <- fmat[8, 2]
      f_05_0 <- fmat[8, 3]
      f_05_1 <- fmat[8, 4]
      f_01_0 <- fmat[8, 5]
      f_01_1 <- fmat[8, 6]
      if (k > 7) {
        fnote <- paste(fnote, "Small-sample critical values only available up to k = 7.", 
                       sep = " ")
      }
    }
  }
  else {
    if (k < 10) {
      k2 <- k + 1
      f_10_0 <- fmat[k2, 1]
      f_10_1 <- fmat[k2, 2]
      f_05_0 <- fmat[k2, 3]
      f_05_1 <- fmat[k2, 4]
      f_01_0 <- fmat[k2, 5]
      f_01_1 <- fmat[k2, 6]
    }
    else {
      f_10_0 <- fmat[11, 1]
      f_10_1 <- fmat[11, 2]
      f_05_0 <- fmat[11, 3]
      f_05_1 <- fmat[11, 4]
      f_01_0 <- fmat[11, 5]
      f_01_1 <- fmat[11, 6]
      if (k > 10) {
        fnote <- paste(fnote, "Asymptotic critical values only available up to k = 10.")
      }
    }
  }
  toutput <- ""
  if (!is.null(tstat)) {
    if (case == 2 | case == 4) {
    }
    else {
      if (k < 10) {
        k2 <- k + 1
        t_10_0 <- tmat[k2, 1]
        t_10_1 <- tmat[k2, 2]
        t_05_0 <- tmat[k2, 3]
        t_05_1 <- tmat[k2, 4]
        t_01_0 <- tmat[k2, 5]
        t_01_1 <- tmat[k2, 6]
      }
      else {
        t_10_0 <- tmat[11, 1]
        t_10_1 <- tmat[11, 2]
        t_05_0 <- tmat[11, 3]
        t_05_1 <- tmat[11, 4]
        t_01_0 <- tmat[11, 5]
        t_01_1 <- tmat[11, 6]
        tnote <- paste(tnote, "Asymptotic critical values only available up to k = 10.")
      }
      toutput <- paste("------------------------------------------------------", 
                       "-                       t-test                       -", 
                       "------------------------------------------------------", 
                       "                <------- I(0) ------------ I(1) ----->", 
                       paste("10% critical value", paste(t_10_0, t_10_1, 
                                                         sep = "            "), sep = "       "), paste("5% critical value", 
                                                                                                        paste(t_05_0, t_05_1, sep = "            "), 
                                                                                                        sep = "        "), paste("1% critical value", 
                                                                                                                                 paste(t_01_0, t_01_1, sep = "            "), 
                                                                                                                                 sep = "        "), "\n", paste("t statistic = ", 
                                                                                                                                                                tstat, sep = ""), sep = "\n ")
    }
  }
  #toutput
  {
    if(case == 1| case == 3 | case == 5){
      tenpct <- cbind(observation = obs, k,fstat = fstat, case = case, lower.b = f_10_0, upper.b = f_10_1)
      fivepct <- cbind(observation = obs, k,fstat = fstat,case = case, lower.b = f_05_0, upper.b = f_05_1)
      onepct <- cbind(observation = obs, k,fstat = fstat,case = case, lower.b = f_01_0, upper.b = f_01_1)
      boundsF <- rbind(tenpct,fivepct,onepct)
      row.names(boundsF) <- c("10% critical value","5% critical value","1% critical value")
      
      tenpct <- cbind(observation = obs, k,tstat = tstat, case = case, lower.b = t_10_0, upper.b = t_10_1)
      fivepct <- cbind(observation = obs, k,tstat = tstat,case = case, lower.b = t_05_0, upper.b = t_05_1)
      onepct <- cbind(observation = obs, k,tstat = tstat,case = case, lower.b = t_01_0, upper.b = t_01_1)
      boundst <- rbind(tenpct,fivepct,onepct)
      row.names(boundst) <- c("10% critical value","5% critical value","1% critical value")
      boundsTest <- list('Fstat'=boundsF, 'tstat'=boundst)
    }
    else{
      tenpct <- cbind(observation = obs, k,fstat = fstat, case = case, lower.b = f_10_0, upper.b = f_10_1)
      fivepct <- cbind(observation = obs, k,fstat = fstat,case = case, lower.b = f_05_0, upper.b = f_05_1)
      onepct <- cbind(observation = obs, k,fstat = fstat,case = case, lower.b = f_01_0, upper.b = f_01_1)
      boundsTest <- rbind(tenpct,fivepct,onepct)
      row.names(boundsTest) <- c("10% critical value","5% critical value","1% critical value")
    }
  }
  boundsTest
}


