% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.R
\name{boot_re}
\alias{boot_re}
\title{wrapper for bootstrap relative efficiency confidence interval}
\usage{
boot_re(
  pred_data,
  period.all,
  model_good,
  bench.all,
  type,
  truth = "CDC.data",
  l = 50,
  N = 10000,
  sim = "geom",
  conf = 0.95
)
}
\arguments{
\item{pred_data}{A matrix that contains the truth vector and the predictions.
It can be data.frame or xts object}

\item{period.all}{vector of the periods to evaluate relative efficiency}

\item{model_good}{The model to evaluate, must be in the column names of pred_data}

\item{bench.all}{vector of the models to compare to, must be in the column names of pred_data}

\item{type}{Must be one of "mse" (mean square error),
"mape" (mean absolute percentage error), or
"mae" (mean absolute error)}

\item{truth}{the column name of the truth}

\item{l}{stationary bootstrap mean block length}

\item{N}{number of bootstrap samples}

\item{sim}{simulation method, pass to boot::tsboot}

\item{conf}{confidence level}
}
\value{
A vector of point estimate and corresponding bootstrap confidence interval
}
\description{
This function is used to wrap the \code{bootstrap_relative_efficiency},
taking vectorized arguments.
}
\examples{
GFT_xts = xts::xts(exp(matrix(rnorm(500), ncol=5)), order.by = Sys.Date() - (100:1))
names(GFT_xts) <- paste0("col", 1:ncol(GFT_xts))
names(GFT_xts)[1] <- "CDC.data"
\donttest{
boot_re(
  pred_data = GFT_xts,
  period.all = c(paste0(zoo::index(GFT_xts)[1], "/", zoo::index(GFT_xts)[50]),
                 paste0(zoo::index(GFT_xts)[51], "/", zoo::index(GFT_xts)[100])),
  model_good = "col2",
  bench.all = c("col3", "col4"),
  type = "mse",
  truth="CDC.data",
  l = 5,
  N = 20
)
}
}
