% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\docType{data}
\name{indexBgc}
\alias{indexBgc}
\title{A Sample Index of Biogeochemical-Argo Profiles}
\description{
This was created by subsetting a global index to the BGC Argo profiles
that were within a 300km radius of Marsh Harbour, Abaco Island,
Bahamas, using the following code.\preformatted{library(argoFloats)
indexAll <- getIndex("bgc")
indexBgc <- subset(indexAll,
    circle=list(longitude=-77.06, latitude=26.54, radius=300))
}
}
\section{Caveat about out-of-date index files}{


Note that the NetCDF files on Argo repositories are changeable,
not just in content, but also in file name.  For example, the data acquired
in a given profile of a given float may initially be provided in real-time
mode (with a file name containing an "R" as the first or second character),
but later be replaced later with a delayed-mode file (with a "D" in the first
or second character). Since index files name data files directly, this means
that index files can become out-of-date, containing references to netcdf
files that no longer exist on the server. This applies to the sample
index files provided with this package, and to user files, and it
explains why \code{\link[=getProfiles]{getProfiles()}} skips over files that cannot be downloaded.
}

\examples{
library(argoFloats)
data(indexBgc)
plot(indexBgc, bathymetry=FALSE)
summary(indexBgc)
unique(indexBgc[["parameters"]])
}
\seealso{
Other datasets provided with argoFloats: 
\code{\link{indexDeep}},
\code{\link{indexSynthetic}},
\code{\link{index}}
}
\concept{datasets provided with argoFloats}
