% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/compact.R
\docType{methods}
\name{remove}
\alias{remove}
\alias{compact}
\alias{compact-method}
\alias{remove_NA}
\alias{remove_NA-method}
\alias{remove_Inf}
\alias{remove_Inf-method}
\alias{remove_zero}
\alias{remove_zero-method}
\alias{remove_empty}
\alias{remove_empty-method}
\alias{compact,ANY,function-method}
\alias{remove_NA,ANY-method}
\alias{remove_Inf,ANY-method}
\alias{remove_zero,ANY-method}
\alias{remove_empty,ANY-method}
\title{Remove values according to a given predicate}
\usage{
compact(x, f, ...)

remove_NA(x, ...)

remove_Inf(x, ...)

remove_zero(x, ...)

remove_empty(x, ...)

\S4method{compact}{ANY,`function`}(x, f, margin = 1, negate = FALSE, all = FALSE)

\S4method{remove_NA}{ANY}(x, margin = 1, all = FALSE)

\S4method{remove_Inf}{ANY}(x, margin = 1, all = FALSE)

\S4method{remove_zero}{ANY}(x, margin = 1, all = FALSE)

\S4method{remove_empty}{ANY}(x, margin = 1)
}
\arguments{
\item{x}{An object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{f}{A predicate \code{\link{function}}.}

\item{...}{Currently not used.}

\item{margin}{A vector giving the subscripts which the function will be
applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{negate}{A \code{\link{logical}} scalar: should the negation of \code{f} be used
instead of \code{f}?}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}
}
\description{
Removes rows/columns in an array-like object according to a given predicate.
}
\details{
\itemize{
\item \code{remove_NA()} remove rows/columns that contain \link[=NA]{missing values}.
\item \code{remove_Inf()} remove rows/columns that contain \link[=is.finite]{infinite values}.
\item \code{remove_zero()} remove rows/columns that contain zero.
\item \code{remove_empty()} is a special case that remove empty rows/columns.
A row/column is empty if it contains only \code{NA}, zeros (if of type
\code{numeric}) or zero length character strings (if of type \code{character}).
}
}
\examples{
## Create a count data matrix
X <- matrix(sample(1:10, 25, TRUE), nrow = 5, ncol = 5)

## Add NA
k <- sample(1:25, 3, FALSE)
X[k] <- NA
X

## Count missing values in rows
count(X, f = is.na, margin = 1)
## Count non-missing values in columns
count(X, f = is.na, margin = 2, negate = TRUE)

## Find row with NA
detect(X, f = is.na, margin = 1)
## Find column without any NA
detect(X, f = is.na, margin = 2, negate = TRUE, all = TRUE)

## Remove row with any NA
compact(X, f = is.na, margin = 1, all = FALSE)
## Remove column with any NA
compact(X, f = is.na, margin = 2, all = FALSE)

## Replace NA with zeros
replace_NA(X, value = 0)
}
\seealso{
Other data cleaning tools: 
\code{\link{assign}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{replace}()}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
