% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset.R
\name{Source}
\alias{Source}
\alias{SourceFactory}
\alias{FileSystemSourceFactory}
\title{Sources for a Dataset}
\description{
A \link{Dataset} can have one or more \code{Source}s. A \code{Source} contains one or more
\code{Fragments}, such as files, of a common type and partitioning.
\code{SourceFactory} is used to create a \code{Source}, inspect the \link{Schema} of the
fragments contained in it, and declare a partitioning.
\code{FileSystemSourceFactory} is a subclass of \code{SourceFactory} for
discovering files in the local file system, the only currently supported
file system.

In general, you'll deal with \code{SourceFactory} rather than \code{Source} itself.

Return the Source's \code{Schema}
}
\section{Factory}{

For the \code{SourceFactory$create()} factory method, see \code{\link[=open_source]{open_source()}}, an
alias for it.

\code{FileSystemSourceFactory$create()} is a lower-level factory method and
takes the following arguments:
\itemize{
\item \code{filesystem}: A \link{FileSystem}
\item \code{selector}: A \link{FileSelector}
\item \code{format}: A string identifier of the format of the files in \code{path}.
Currently supported options are "parquet", "arrow", and "ipc" (an alias for
the Arrow file format)
}
}

\section{Methods}{

\code{Source} has one defined method:
\itemize{
\item \verb{$schema}: Active binding, returns the \link{Schema} of the \code{Source}
}

\code{SourceFactory} and its subclasses have the following methods:
\itemize{
\item \verb{$Inspect()}: Walks the files in the directory and returns a common \link{Schema}
\item \verb{$Finish(schema)}: Returns a \code{Source}
}
}

\seealso{
\link{Dataset} for what do do with a \code{Source}
}
