% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipc_stream.R, R/deprecated.R
\name{read_ipc_stream}
\alias{read_ipc_stream}
\alias{read_table}
\alias{read_arrow}
\title{Read Arrow IPC stream format}
\usage{
read_ipc_stream(x, as_data_frame = TRUE, ...)

read_table(x, ...)

read_arrow(x, ...)
}
\arguments{
\item{x}{A character file name, \code{raw} vector, or an Arrow input stream}

\item{as_data_frame}{Should the function return a \code{data.frame} (default) or
an Arrow \link{Table}?}

\item{...}{extra parameters passed to \code{read_feather()}.}
}
\value{
A \code{data.frame} if \code{as_data_frame} is \code{TRUE} (the default), or an
Arrow \link{Table} otherwise
}
\description{
Apache Arrow defines two formats for \href{https://arrow.apache.org/docs/format/Columnar.html#serialization-and-interprocess-communication-ipc}{serializing data for interprocess communication (IPC)}:
a "stream" format and a "file" format, known as Feather. \code{read_ipc_stream()}
and \code{\link[=read_feather]{read_feather()}} read those formats, respectively.
}
\details{
\code{read_arrow()}, a wrapper around \code{read_ipc_stream()} and \code{read_feather()},
is deprecated. You should explicitly choose
the function that will read the desired IPC format (stream or file) since
a file or \code{InputStream} may contain either. \code{read_table()}, a wrapper around
\code{read_arrow()}, is also deprecated
}
\seealso{
\code{\link[=read_feather]{read_feather()}} for writing IPC files. \link{RecordBatchReader} for a
lower-level interface.
}
