% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{infer_type}
\alias{infer_type}
\alias{type}
\title{Infer the arrow Array type from an R object}
\usage{
infer_type(x, ...)

type(x)
}
\arguments{
\item{x}{an R object (usually a vector) to be converted to an \link{Array} or
\link{ChunkedArray}.}

\item{...}{Passed to S3 methods}
}
\value{
An arrow \link[=data-type]{data type}
}
\description{
Infer the arrow Array type from an R object
}
\examples{
\dontshow{if (arrow_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
infer_type(1:10)
infer_type(1L:10L)
infer_type(c(1, 1.5, 2))
infer_type(c("A", "B", "C"))
infer_type(mtcars)
infer_type(Sys.Date())
infer_type(as.POSIXlt(Sys.Date()))
infer_type(vctrs::new_vctr(1:5, class = "my_custom_vctr_class"))
\dontshow{\}) # examplesIf}
}
