% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freqlist.internal.R
\name{freqlist.internal}
\alias{freqlist.internal}
\alias{is.freqlist}
\alias{is.summary.freqlist}
\alias{head.summary.freqlist}
\alias{tail.summary.freqlist}
\alias{sort.freqlist}
\title{Helper functions for freqlist}
\usage{
is.freqlist(x)

is.summary.freqlist(x)

\method{head}{summary.freqlist}(x, n = 6L, ...)

\method{tail}{summary.freqlist}(x, n = 6L, ...)

\method{sort}{freqlist}(x, decreasing = FALSE, ...)
}
\arguments{
\item{x}{A \code{freqlist} object.}

\item{n}{A single integer. See \code{\link[utils]{head}} or \code{\link[utils]{tail}} for more details}

\item{...}{Other arguments.}

\item{decreasing}{Should the sort be increasing or decreasing?}
}
\description{
A set of helper functions for \code{\link{freqlist}}.
}
\details{
Note that \code{sort()} has to recalculate cumulative statistics. Note also that the reordering of rows
  will also affect which labels are duplicates; you may also want to consider using
  \code{dupLabels=TRUE} in \code{\link{freq.control}()}.
}
\seealso{
\code{\link{merge.freqlist}}, \code{\link{arsenal_table}}, \code{\link{sort}},
  \code{\link{freqlist}}, \code{\link{summary.freqlist}}, \code{\link{freq.control}},
}
