% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/asVPCdistanceW.R
\name{asVPC.distanceW}
\alias{asVPC.distanceW}
\title{calculate percentiles of original data using distance-related weight
percentiles of simulated data with corresponding confidence interval}
\usage{
asVPC.distanceW(orig.data, sim.data, n.timebin, n.sim, n.hist,
  q.list = c(0.05, 0.5, 0.95), conf.level = 0.95, X.name = "TIME",
  Y.name = "DV", opt.DV.point = FALSE, weight.flag = FALSE,
  Y.min = NULL, Y.max = NULL, only.med = FALSE, plot.flag = TRUE)
}
\arguments{
\item{orig.data}{the original data for model fitting}

\item{sim.data}{the simulated data from NONMEM}

\item{n.timebin}{the number of bin in X axis}

\item{n.sim}{the number of simulation in the simulated data}

\item{n.hist}{the number of shifted}

\item{q.list}{numeric vector of probabilities with values in [0,1]}

\item{conf.level}{confidence level of the interval}

\item{X.name}{the name of X variable in the original scatter plot}

\item{Y.name}{the name of Y variable in the original scatter plot}

\item{opt.DV.point}{option to put data point in the plot}

\item{weight.flag}{option to use weight in average shifted calculation}

\item{Y.min}{minimum of Y range in the plot}

\item{Y.max}{maximum of Y range in the plot}

\item{only.med}{option to use only median}

\item{plot.flag}{TRUE: drawing plot / FALSE: generate data for drawing plot}
}
\value{
plot or the values to draw plot
}
\description{
calculate percentiles of original data using distance-related weight
percentiles of simulated data with corresponding confidence interval
}
\examples{
data(origdata)
data(simdata)
asVPC.distanceW(origdata,simdata,n.timebin=10, n.sim=100,n.hist=3)
}
\author{
Eun-Kyung Lee \email{lee.eunk@gmail.com}
}
\references{
new paper...
}
\seealso{
\code{\link{asVPC.binW}}
}

