% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record.R
\name{asciicast_start_process}
\alias{asciicast_start_process}
\title{Start an asciicast background process}
\usage{
asciicast_start_process(
  timeout = 10,
  allow_errors = TRUE,
  startup = NULL,
  record_env = NULL,
  echo = TRUE
)
}
\arguments{
\item{timeout}{Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops. Update this for slow running code, that produces no
output as it runs.}

\item{allow_errors}{Whether to cast errors properly. If this is set to
\code{TRUE}, then asciicast overwrites the \code{"error"} option. Only change
this if you know what you are doing.}

\item{startup}{Quoted language object to run in the subprocess before
starting the recording.}

\item{record_env}{Environment variables to set for the R subprocess.}

\item{echo}{Whether to echo the input to the terminal. If \code{FALSE}, then
only the output is shown.}
}
\value{
The R process, a \link[processx:process]{processx::process} object.
}
\description{
This is for expert use, if you want to run multiple recordings in the
same process.
}
\examples{
\dontshow{if (asciicast:::is_recording_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use the same R process to record multiple casts
process <- asciicast_start_process()
script1 <- "a <- runif(10)\n"
script2 <- "a\n"
cast1 <- record(textConnection(script1), process = process)
cast2 <- record(textConnection(script2), process = process)
cast1
cast2
\dontshow{\}) # examplesIf}
}
\seealso{
Other asciicast functions: 
\code{\link{asciicast-package}},
\code{\link{read_cast}()},
\code{\link{record}()},
\code{\link{write_json}()}
}
\concept{asciicast functions}
