% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asciicast.R
\name{record}
\alias{record}
\title{Record an asciinema screencast}
\usage{
record(
  script,
  typing_speed = NULL,
  empty_wait = NULL,
  cols = NULL,
  rows = NULL,
  title = NULL,
  timestamp = NULL,
  env = NULL,
  idle_time_limit = NULL,
  timeout = NULL,
  start_wait = NULL,
  end_wait = NULL,
  record_env = NULL,
  startup = NULL,
  echo = TRUE,
  speed = NULL,
  process = NULL,
  interactive = TRUE,
  locales = get_locales(),
  options = asciicast_options(),
  incomplete_error = NULL,
  show_output = FALSE
)
}
\arguments{
\item{script}{Path of an R script to record. It can also be a readable
R connection or URL, as it is passed to \code{\link[base:readLines]{base::readLines()}}. It can also
be a language object, which is deparsed, or a character vector with
the source code itself.}

\item{typing_speed}{Average typing speed, per keypress, in seconds.}

\item{empty_wait}{How long to wait for empty lines in the script file,
in seconds.}

\item{cols}{Width of the terminal, in number of characters.}

\item{rows}{Height of the terminal, in number of characters. If it the
string \code{"auto"}, then it will be determined automatically, by including
all output on the screen.}

\item{title}{Title of the cast, this is included in the cast JSON file.}

\item{timestamp}{Time stamp of the recording, defaults to \code{Sys.time()},
this is included in the cast JSON file.}

\item{env}{Environment variables to include in the case JSON file.
Defaults to \code{list(TERM = "xterm-256color", SHELL = "/bin/zsh")}.}

\item{idle_time_limit}{Time limit for the cast not printing anything,
in seconds. By default there is no limit.}

\item{timeout}{Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops. Update this for slow running code, that produces no
output as it runs.}

\item{start_wait}{Delay at the beginning, in seconds.}

\item{end_wait}{Delay at the very end, in seconds.}

\item{record_env}{Environment variables to set for the R subprocess.}

\item{startup}{Quoted language object to run in the subprocess before
starting the recording.}

\item{echo}{Whether to echo the input to the terminal. If \code{FALSE}, then
only the output is shown.}

\item{speed}{Rescale the speed of the recorded cast with this factor.
The delay of the first frame is kept constant.}

\item{process}{A processx subprocess to run the cast in. By default a
new subprocess is started. You can reuse a process by calling
\code{\link[=asciicast_start_process]{asciicast_start_process()}} first, and supplying the returned process
here.}

\item{interactive}{Whether to run R in interactive mode. This argument
is ignored if \code{process} is specified. If \code{process} is \code{NULL} then
it is passed to \code{\link[=asciicast_start_process]{asciicast_start_process()}}.}

\item{locales}{Locales to set in the asciicast subprocess. Defaults
to the current locales in the main R process. Specify a named character
vector here to override some of the defaults. See also \code{\link[=get_locales]{get_locales()}}.}

\item{options}{Options to set in the subprocess, a named list.
They are deparsed to code, and then the code setting them is
executed in the subprocess. See \code{\link[=asciicast_options]{asciicast_options()}} for the
defaults. Supply a named list here to override the defaults or set
additionsl ones. Passing large and/or complicated options here might
not work, or might be slow.}

\item{incomplete_error}{Whether to error on incomplete expressions.
You might need to set this to \code{FALSE} for R code that does keyboard
input, e.g. in \code{browser()}. The default is \code{TRUE}.}

\item{show_output}{Whether to show the output of the subprocess in
real time.}
}
\value{
An \code{asciicast} object, write this to
file with \code{\link[=write_json]{write_json()}}.
}
\description{
Record an asciinema screencast
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
script <- system.file("examples", "hello.R", package = "asciicast")
cast <- record(script)
play(cast)
\dontshow{\}) # examplesIf}
}
\seealso{
Other asciicast functions: 
\code{\link{asciicast-package}},
\code{\link{asciicast_start_process}()},
\code{\link{read_cast}()},
\code{\link{write_json}()}
}
\concept{asciicast functions}
