% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_type.R
\name{assert_numeric}
\alias{assert_numeric}
\title{Assert input is numeric}
\usage{
assert_numeric(x, msg = NULL, call = rlang::caller_env(), arg_name = NULL)
}
\arguments{
\item{x}{An object}

\item{msg}{A character string containing the error message to display if \code{x} is not numeric}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is numeric, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert an R object is numeric
Works for \strong{vector} and \strong{matrix} objects.
To assert an object is specifically a \strong{numeric vector} see \code{\link[=assert_numeric_vector]{assert_numeric_vector()}}
}
\examples{
try({
assert_numeric(1:3) # Passes
assert_numeric(1.5:5.5) # Passes
assert_numeric(c("a", "b", "c")) # Throws default error
assert_numeric(c("a", 1, "b"), "Custom error message") # Throws custom error
})


}
\concept{assert_type}
