% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-code.R, R/is-code.R
\name{assert_is_loaded}
\alias{assert_is_loaded}
\alias{is_loaded}
\title{Is the input a symbol in a loaded DLL?}
\usage{
assert_is_loaded(x, severity = getOption("assertive.severity", "stop"))

is_loaded(
  x,
  PACKAGE = "",
  type = c("", "C", "Fortran", "Call", "External"),
  .xname = get_name_in_parent(x)
)
}
\arguments{
\item{x}{A string naming the symbol in a DLL to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{PACKAGE}{A string naming an R package to restrict the search to, or 
\code{""} to check all packages. Passed to \code{is.loaded}.}

\item{type}{A string naming the type of external code call to restrict the
search to, or \code{""} to check all type. Passed to \code{is.loaded}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_loaded} wraps \code{\link[base]{is.loaded}}, providing more 
information on failure.  \code{assert_is_loaded} returns nothing but
throws an error if \code{is_loaded} returns \code{FALSE}
}
\description{
Checks to see if the input DLL (a.k.a. shared object) is loaded.
}
\note{
From R 4.4.0, DLL for base packages are not searchable, so 
\code{is.loaded} returns FALSE, so \code{is_loaded} also returns FALSE.
}
\seealso{
\code{\link[base]{is.loaded}}.
}
