% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-function.R, R/is-function.R
\name{assert_is_s3_generic}
\alias{assert_is_s3_generic}
\alias{assert_is_s3_group_generic}
\alias{assert_is_s3_internal_generic}
\alias{assert_is_s3_method}
\alias{assert_is_s3_primitive_generic}
\alias{assert_is_s4_group_generic}
\alias{is_s3_generic}
\alias{is_s3_group_generic}
\alias{is_s3_internal_generic}
\alias{is_s3_method}
\alias{is_s3_primitive_generic}
\alias{is_s4_group_generic}
\title{Is the input an S3 generic or method?}
\usage{
assert_is_s3_generic(x, severity = getOption("assertive.severity", "stop"))

assert_is_s3_method(x, severity = getOption("assertive.severity", "stop"))

assert_is_s3_primitive_generic(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_s3_group_generic(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_s4_group_generic(x, severity = getOption("assertive.severity",
  "stop"))

assert_is_s3_internal_generic(x, severity = getOption("assertive.severity",
  "stop"))

is_s3_generic(x, .xname = get_name_in_parent(x))

is_s3_method(x, .xname = get_name_in_parent(x))

is_s3_primitive_generic(x, .xname = get_name_in_parent(x))

is_s3_group_generic(x, .xname = get_name_in_parent(x))

is_s4_group_generic(x, groups = c("Arith", "Compare", "Ops", "Logic", "Math",
  "Math2", "Summary", "Complex"), .xname = get_name_in_parent(x))

is_s3_internal_generic(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}

\item{groups}{A character vector of S4 group generic groups.}
}
\value{
\code{is_internal_function} returns \code{TRUE} when the input is a 
closure function that calls \code{\link[base]{.Internal}}.  The 
\code{assert_*} function returns nothing but throw an error if the 
corresponding \code{is_*} function returns \code{FALSE}.
}
\description{
Checks whether the input is an S3 generic or method.
}
\examples{
# General check for S3 generics and methods
is_s3_generic(is.na)
is_s3_method(is.na.data.frame)

# More specific types of S3 generic
is_s3_primitive_generic(c)
is_s3_group_generic(abs)
is_s3_internal_generic(unlist)

# S4 group generics are mostly the same as S3 group generics
is_s4_group_generic(cosh)

# Renaming functions is fine
not <- `!`
is_s3_group_generic(not)

# Some failures
assertive.base::dont_stop({
assert_is_s3_primitive_generic(exp)
assert_is_s4_group_generic(`!`)
})
}
\references{
\code{is_s3_generic} is based upon
\code{\link[pryr]{is_s3_generic}}. Similarly, \code{is_s3_method} is based
upon \code{find_generic}, internal to \code{pryr}, with some ideas from
\code{\link[utils]{isS3method}}.
\code{is_primitive_generic} checks for the functions listed by
\code{\link[base]{.S3PrimitiveGenerics}}.
\code{is_s3_group_generic} checks for the functions listed by 
\code{.get_internal_S3_generics}, internal to the \code{tools} package.
\code{is_s4_group_generic} checks for the functions listed by
\code{\link[methods]{getGroupMembers}}. S4 group generics are mostly the same
as S3 group generics, except that the not operator, \code{!}, is S3 group 
generic but not S4, and \code{log2} and \code{log10} are S4
group generic but not S3.
\code{is_s3_internal_generic} checks for the functions listed by
\code{.get_internal_S3_generics}, internal to the \code{tools} package.
\code{internal_generics}, internal to \code{pryr} works similarly, though
checks for S4 group generics rather than S3 group generics.
There is some discussion of group generics scatterd throughout R-internals.
In particular, see the section on the Mechanics of S4 Dispatch.
\url{https://cran.r-project.org/doc/manuals/r-devel/R-ints.html#Mechanics-of-S4-dispatch}
}
\seealso{
\code{\link[base]{is.function}} and its assertive wrapper
\code{\link{is_function}}.
\code{\link{is_closure_function}} to check for closures/builtin and
special functions.
\code{\link{is_internal_function}} to check for functions that use the
\code{\link[base]{.Internal}} interface to C code.
}

