% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_sample_htest.R
\name{multi_sample_htest}
\alias{multi_sample_htest}
\alias{multi_sample_htest.logical}
\alias{multi_sample_htest.factor}
\alias{multi_sample_htest.character}
\alias{multi_sample_htest.ordered}
\alias{multi_sample_htest.numeric}
\title{Calculates multi sample hypothesis tests}
\usage{
multi_sample_htest(value, group, ...)

\method{multi_sample_htest}{logical}(value, group, ...)

\method{multi_sample_htest}{factor}(value, group,
  multi_sample_htest.factor = NULL, ...)

\method{multi_sample_htest}{character}(value, group, ...)

\method{multi_sample_htest}{ordered}(value, group,
  multi_sample_htest.ordered = NULL, ...)

\method{multi_sample_htest}{numeric}(value, group,
  multi_sample_htest.numeric = NULL, ...)
}
\arguments{
\item{value}{An atomic vector.}

\item{group}{A factor, same length as \code{value}.}

\item{...}{Passed to methods.}

\item{multi_sample_htest.factor}{Analog to argument two_sample_htest.numeric}

\item{multi_sample_htest.ordered}{Analog to argument two_sample_htest.numeric}

\item{multi_sample_htest.numeric}{Either \code{NULL} or a function. Default is \code{NULL}.
If a function, then it will replace \code{atable:::multi_sample_htest.numeric}.
The function must mimic \code{\link{multi_sample_htest.numeric}}: arguments are
\code{value}, \code{group} and the ellipsis ... .
Result is a named list with \code{length} > 0 with unique names.}
}
\value{
A named list with length > 0.

Most hypothesis-test-functions in R like \code{\link[stats]{t.test}} or \code{\link[stats]{chisq.test}} return an
object of class \code{'htest'}. \code{'htest'}-objects are a suitable output for function \code{two_sample_htest}.
Function \code{\link{check_tests}} checks if the output is suitable for further processing.
}
\description{
Calculates multi sample hypothesis tests depending on the class of its input.
}
\details{
Calculates multi sample hypothesis tests depending on the class of its input.

Results are passed to function \code{format_tests} for the final table.

If you are not pleased with the current hypothesis tests you may alter these functions.
But you must keep the original output-format, see section Value.
Function \code{\link{check_tests}} checks if the output of statistics is suitable for further processing.

The function \code{multi_sample_htest} is essentially a wrapper
to standardize the arguments of various hypothesis test functions.
}
\section{Methods (by class)}{
\itemize{
\item \code{logical}: Casts to factor and then calls method \code{multi_sample_htest} again.

\item \code{factor}: Calls \code{\link[stats]{chisq.test}}.

\item \code{character}: Casts \code{value} to factor and then calls method \code{multi_sample_htest} again.

\item \code{ordered}: Calls \code{\link[stats]{kruskal.test}}.

\item \code{numeric}: Calls \code{multi_sample_htest}'s method on \code{ordered(value)}.
}}

