% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if.R
\name{if_then}
\alias{if_then}
\alias{if_not}
\alias{if_else}
\title{If this, then that}
\usage{
if_then(.x, .p = isTRUE, .f)

if_not(.x, .p = isTRUE, .f)

if_else(.x, .p = isTRUE, .f, .else)
}
\arguments{
\item{.x}{the object to test. If \code{NULL} (the default), only .p is evaluated.}

\item{.p}{the predicate for testing. Defaut is \code{isTRUE}.}

\item{.f}{a mapper or a function run if .p(.x) is TRUE}

\item{.else}{a mapper or a function run if .p(.x) is not TRUE}
}
\value{
Depending on wether or not .p(.x) is TRUE, .f() or .else() is run.
}
\description{
If this, then that
}
\note{
If you want these function to return a value,
  you need to wrap these values into a mapper / a function. E.g, to return
  a vector, you'll need to write \code{if_then(1, is.numeric, ~ "Yay")}.
}
\examples{
a <- if_then(1, is.numeric, ~ "Yay")
a <- if_not(1, is.character, ~ "Yay")
a <- if_else(.x = TRUE, .f = ~ "Yay", .else = ~ "Nay")
}
