% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmentedRCBD.bulk.R
\name{augmentedRCBD.bulk}
\alias{augmentedRCBD.bulk}
\title{Analysis of Augmented Randomised Complete Block Design for Multiple
Traits/Characters}
\usage{
augmentedRCBD.bulk(data, block, treatment, traits, checks = NULL,
  alpha = 0.05, describe = TRUE, freqdist = TRUE, gva = TRUE,
  check.col = "red", console = TRUE)
}
\arguments{
\item{data}{The data as a data frame object. The data frame should possess
columns specifying the block, treatment and multiple traits/characters.}

\item{block}{Name of column specifying the blocks in the design as a
character string.}

\item{treatment}{Name of column specifying the treatments as a character
string.}

\item{traits}{Name of columns specifying the multiple traits/characters as a
character vector.}

\item{checks}{Character vector of the checks present in \code{treatment}
levels. If not specified, checks are inferred from the data on the basis of
number of replications of treatments/genotypes.}

\item{alpha}{Type I error probability (Significance level) to be used for
multiple comparisons.}

\item{describe}{If \code{TRUE}, descriptive statistics will be computed.
Default is \code{TRUE}.}

\item{freqdist}{If \code{TRUE}, frequency distributions be plotted. Default
is \code{TRUE}.}

\item{gva}{If \code{TRUE}, genetic variability analysis will be done. Default
is \code{TRUE}.}

\item{check.col}{The colour(s) to be used to highlight check values in the
plot as a character vector. Must be valid colour values in R (named
colours, hexadecimal representation, index of colours [\code{1:8}] in
default R `palette()` etc.).}

\item{console}{If \code{TRUE}, output will be printed to console. Default is
\code{TRUE}.}
}
\value{
A list of class \code{augmentedRCBD.bulk} containing the following
  components:  \item{\code{Details}}{Details of the augmented design used and
  the traits/characters.} \item{\code{ANOVA, Treatment Adjusted}}{A data
  frame of mean sum of squares of the specified traits from treatment
  adjusted ANOVA.} \item{\code{ANOVA, Block Adjusted}}{A data frame of mean
  sum of squares of the specified traits from block adjusted ANOVA}
  \item{\code{Means}}{A data frame of the adjusted means of the treatments
  for the specified traits.} \item{\code{alpha}}{Type I error probability
  (Significance level) used.} \item{\code{Std. Errors}}{A data frame of
  standard error of difference between various combinations for the specified
  traits.} \item{\code{CD}}{A data frame of critical difference (at the
  specified alpha) between various combinations for the specified traits.}
  \item{\code{Overall adjusted mean}}{A data frame of the overall adjusted
  mean for the specified traits.} \item{\code{CV}}{A data frame of the
  coefficient of variance for the specified traits.} \item{\code{Descriptive
  statistics}}{A data frame of descriptive statistics for the specified
  traits.} \item{\code{Frequency distribution}}{A list of ggplot2 plot grobs
  of the frequency distribution plots.} \item{\code{Genetic variability
  analysis}}{A data frame of genetic variability statistics for the specified
  traits.} \item{\code{GVA plots}}{A list of three ggplot2 objects with the
  plots for (a) Phenotypic and Genotypic CV, (b) Broad sense heritability and
  (c) Genetic advance over mean} \item{\code{warnings}}{A list of warning
  messages (if any) captured during model fitting and frequency distribution
  plotting.}
}
\description{
\code{augmentedRCBD.bulk} is a wrapper around the functions
\code{augmentedRCBD}, \code{describe.augmentedRCBD},
\code{freqdist.augmentedRCBD} and \code{gva.augmentedRCBD}. It will carry out
these analyses for multiple traits/characters from the input data as a data
frame object.
}
\note{
In this case treatment comparisons/grouping by least significant
  difference or Tukey's honest significant difference method is not computed.
  Also the output object size is reduced using the \code{simplify = TRUE}
  argument in the \code{augmentedRCBD} function.
}
\examples{
# Example data
blk <- c(rep(1,7),rep(2,6),rep(3,7))
trt <- c(1, 2, 3, 4, 7, 11, 12, 1, 2, 3, 4, 5, 9, 1, 2, 3, 4, 8, 6, 10)

y1 <- c(92, 79, 87, 81, 96, 89, 82, 79, 81, 81, 91, 79, 78, 83, 77, 78, 78,
        70, 75, 74)
y2 <- c(258, 224, 238, 278, 347, 300, 289, 260, 220, 237, 227, 281, 311, 250,
        240, 268, 287, 226, 395, 450)
dataf <- data.frame(blk, trt, y1, y2)

bout <- augmentedRCBD.bulk(data = dataf, block = "blk",
                           treatment = "trt", traits = c("y1", "y2"),
                           checks = NULL, alpha = 0.05, describe = TRUE,
                           freqdist = TRUE, gva = TRUE,
                           check.col = c("brown", "darkcyan",
                                         "forestgreen", "purple"),
                           console = TRUE)

# Frequency distribution plots
lapply(bout$`Frequency distribution`, plot)

# GVA plots
bout$`GVA plots`

}
\seealso{
\code{\link[augmentedRCBD]{augmentedRCBD}},
  \code{\link[augmentedRCBD]{describe.augmentedRCBD}},
  \code{\link[augmentedRCBD]{freqdist.augmentedRCBD}},
  \code{\link[augmentedRCBD]{gva.augmentedRCBD}}
}
