% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reliability.R
\name{checkRel}
\alias{checkRel}
\alias{summary.seprel}
\title{Compute Reliability and Standard Error}
\usage{
checkRel(obj)

\method{summary}{seprel}(object, ...)
}
\arguments{
\item{obj}{Object that resulted from any models estimation, e.g., \code{pcm}, \code{gpcm}, \code{pcmdif}, and \code{gpcmdif}.}

\item{object}{The object of class \code{'seprel'}.}

\item{...}{Further arguments to be passed.}
}
\value{
A list of two objects, the reliability and the standard error.

\emph{reliability}
\itemize{
\item{PRI}{   Person reliability index.}
\item{PSR}{   Person separation reliability.}
\item{IRI}{   Item reliability index.}
\item{ISR}{   Item separation reliability.}
}
\emph{stdError}
\itemize{
\item{var_err_pers}{   A matrix of variance error of the estimation.}
\item{std_err_pers}{   A matrix of standard error of the estimation.}
\item{rmsse_pers}{   Root mean square of the standard error per person.}
\item{var_err_item}{   A matrix of variance error of the estimation.}
\item{std_err_item}{   A matrix of standard error of the estimation.}
\item{rmsse_item}{   Root mean square of the standard error per person.}
\item{hessian_theta}{   Hessian matrix of \code{theta} parameter.}
\item{hessian_beta}{   Hessian matrix of \code{beta} parameter.}
}
}
\description{
This function computes the reliability index, separation and the standard error of the models estimation.
}
\details{
Person reliability index
}
\examples{
pcmObject <- pcm(shortDIF)
rel <- checkRel(pcmObject)
summary(rel)

}
