% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myft.R
\name{myft}
\alias{myft}
\title{Convert data.frame into flextable}
\usage{
myft(x, vanilla = TRUE, fontsize = 10, digits, showid = FALSE, ...)
}
\arguments{
\item{x}{A data.frame}

\item{vanilla}{logical}

\item{fontsize}{Numeric}

\item{digits}{integer indicating the position of decimal place}

\item{showid}{logical if TRUE, show id}

\item{...}{Further arguments to be passed to df2flextable()}
}
\value{
An object of class \code{\link[flextable]{flextable}}
}
\description{
Convert data.frame into flextable
}
\examples{
data(acs,package="moonBook")
library(dplyr)
gaze(acs) \%>\% myft()
gaze(sex~.,acs) \%>\% myft()
\donttest{
gaze(sex+Dx~.,data=acs,show.p=TRUE,show.total=TRUE,show.n=TRUE,shiw.missing=TRUE) \%>\% myft()
gaze(Dx+sex~cardiogenicShock,data=acs,show.p=TRUE) \%>\% myft()
gaze(Dx+sex+HBP~cardiogenicShock,data=acs,show.p=TRUE) \%>\% myft()
}
}
