% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{autocart}
\alias{autocart}
\title{Create an autocart model}
\usage{
autocart(response, data, locations, alpha, beta, control = NULL)
}
\arguments{
\item{response}{A vector of numeric response values with no NA entries.}

\item{data}{A dataframe for the predictor variables used in the autocart tree.}

\item{locations}{A two-column matrix with coordinates for the observations the predictor dataframe.}

\item{alpha}{A scalar value between 0 and 1 to weight autocorrelation against reduction in variance in the tree splitting. A value of 1 indicates full weighting on measures of autocorrelation.}

\item{beta}{A scalar value between 0 and 1 to weight the shape of the region in the splitting}

\item{control}{An object of type "autocartControl" returned by the \code{autocartControl} function to control the splitting in the autocart tree.}
}
\value{
An S3 object of class "autocart".
}
\description{
Create an autocart model
}
\examples{
# Load some data for an autocart example
snow <- na.omit(read.csv(system.file("extdata", "ut2017_snow.csv", package = "autocart")))
y <- snow$yr50[1:40]
X <- data.frame(snow$ELEVATION, snow$MCMT, snow$PPTWT, snow$HUC)[1:40, ]
locations <- as.matrix(cbind(snow$LONGITUDE, snow$LATITUDE))[1:40, ]

# Create an autocart model with 50 trees
snow_model <- autocart(y, X, locations, 0.30, 0)

}
