% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestharp.R
\name{fapply}
\alias{fapply}
\title{Apply a function to a forest of trees.}
\usage{
fapply(fharp, TFUN, combine = TRUE, combiner_fn, ...)
}
\arguments{
\item{fharp}{The output of rmd_to_forestharp. It could also just be a 
list of TreeHarp objects.}

\item{TFUN}{A function that works on a single TreeHarp and returns an output. 
See \link{forestharp-helpers} for examples.}

\item{combine}{A logical value that indicates if the output from all function
applications should be combined.}

\item{combiner_fn}{A function to use to combine the individual output from 
each tree into a single scalar for each forest. It should handle NA 
values in the input vector or list. If it is missing, it defaults to 
sum, with na.rm=TRUE.}

\item{...}{Additional arguments to be passed on to TFUN.}
}
\value{
A vector, list or a single value. If TFUN returned an error for a 
particular TreeHarp, that component in the list or vector would be NA. This 
input vector or list will then be combined by combiner_fn.
}
\description{
A convenience function, for applying a function to many trees.
}
\details{
The input is simply a list of TreeHarp objects. First, the TFUN 
function is lapply-ed to each TreeHarp item, resulting in either a list, 
or a vector with possible NA elements.

The combiner function should be aware of this sort of output, and summarise
the list or vector accordingly, handling NA's and returning a \emph{scalar}.

If you need to create a partial function out of a forestharp helper, 
use an anonymous function, as shown in the examples below.
}
\examples{

ex1 <- quote(X <- rnorm(10, mean=0.9, sd=4))
ex2 <- quote(Y <- rbeta(10, shape1=3, shape2=5))
f1 <- lapply(c(ex1, ex2), TreeHarp, quote_arg=TRUE) 

# returns all function calls that begin with "r", like rnorm and rbeta.
# calls are returned as a list.
fapply(f1, extract_fn_call, combine =FALSE, pattern="^r.*")

# list is catenated.
fapply(f1, extract_fn_call, combine =TRUE, pattern="^r.*", 
       combiner_fn = function(x) {paste0(unlist(x), collapse=",")})

}
