% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_local_gateway_virtual_interface_groups}
\alias{ec2_describe_local_gateway_virtual_interface_groups}
\title{Describe Local Gateway Virtual Interface Groups}
\usage{
ec2_describe_local_gateway_virtual_interface_groups(
  LocalGatewayVirtualInterfaceGroupId = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{LocalGatewayVirtualInterfaceGroupId}{List. The IDs of the virtual interface groups.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes the specified local gateway
virtual interface groups.
}
\section{LocalGatewayVirtualInterfaceGroupId}{

The IDs of the virtual
interface groups.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{local-gateway-id} - The ID of a local gateway.
\item \code{local-gateway-virtual-interface-id} - The ID of the virtual
interface.
\item \code{local-gateway-virtual-interface-group-id} - The ID of the virtual
interface group.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

\section{DryRun}{

Checks whether you have the
required permissions for the action, without actually making the
request, and provides an error response. If you have the required
permissions, the error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

