% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_reserved_instances_offerings}
\alias{ec2_describe_reserved_instances_offerings}
\title{Describe Reserved Instances Offerings}
\usage{
ec2_describe_reserved_instances_offerings(
  AvailabilityZone = NULL,
  Filter = NULL,
  IncludeMarketplace = NULL,
  InstanceType = NULL,
  MaxDuration = NULL,
  MaxInstanceCount = NULL,
  MinDuration = NULL,
  OfferingClass = NULL,
  ProductDescription = NULL,
  ReservedInstancesOfferingId = NULL,
  DryRun = NULL,
  InstanceTenancy = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  OfferingType = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{AvailabilityZone}{String. The Availability Zone in which the Reserved Instance can be used.[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{IncludeMarketplace}{Logical. Include Reserved Instance Marketplace offerings in the response.[optional]}

\item{InstanceType}{String. The instance type that the reservation will cover (for example, \code{m1.small}). For more information,...[optional]}

\item{MaxDuration}{Integer.   The maximum duration (in seconds) to filter when searching for offerings.[optional]}

\item{MaxInstanceCount}{Integer.   The maximum number of instances to filter when searching for offerings.  Default: 20  [optional]}

\item{MinDuration}{Integer.   The minimum duration (in seconds) to filter when searching for offerings.[optional]}

\item{OfferingClass}{String. The offering class of the Reserved Instance. Can be \code{standard} or \code{convertible}.[optional]}

\item{ProductDescription}{String. The Reserved Instance product platform description.[optional]}

\item{ReservedInstancesOfferingId}{List. One or more Reserved Instances offering IDs.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{InstanceTenancy}{String.   The tenancy of the instances covered by the reservation.[optional]}

\item{MaxResults}{Integer.   The maximum number of results to return for the request in a single page.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{OfferingType}{String. The Reserved Instance offering type.[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describe Reserved Instances Offerings
}
\section{AvailabilityZone}{

The Availability Zone in which the Reserved
Instance can be used.
}

\section{Filter}{


One or more filters.
\itemize{
\item \code{availability-zone} - The Availability Zone where the Reserved
Instance can be used.
\item \code{duration} - The duration of the Reserved Instance (for example, one
year or three years), in seconds (\code{31536000} \| \code{94608000}).
\item \code{fixed-price} - The purchase price of the Reserved Instance (for
example, 9800.0).
\item \code{instance-type} - The instance type that is covered by the
reservation.
\item \code{marketplace} - Set to \code{true} to show only Reserved Instance
Marketplace offerings. When this filter is not used, which is the
default behavior, all offerings from both AWS and the Reserved
Instance Marketplace are listed.
\item \code{product-description} - The Reserved Instance product platform
description. Instances that include \verb{(Amazon VPC)} in the product
platform description will only be displayed to EC2-Classic account
holders and are for use with Amazon VPC. (\code{Linux/UNIX} \|
\verb{Linux/UNIX (Amazon VPC)} \| \verb{SUSE Linux} \|
\verb{SUSE Linux (Amazon VPC)} \| \verb{Red Hat Enterprise Linux} \|
\verb{Red Hat Enterprise Linux (Amazon VPC)} \| \code{Windows} \|
\verb{Windows (Amazon VPC)} \| \verb{Windows with SQL Server Standard} \|
\verb{Windows with SQL Server Standard (Amazon VPC)} \|
\verb{Windows with SQL Server Web} \|
\verb{ Windows with SQL Server Web (Amazon VPC)} \|
\verb{Windows with SQL Server Enterprise} \|
\verb{Windows with SQL Server Enterprise (Amazon VPC)})
\item \code{reserved-instances-offering-id} - The Reserved Instances offering
ID.
\item \code{scope} - The scope of the Reserved Instance (\verb{Availability Zone} or
\code{Region}).
\item \code{usage-price} - The usage price of the Reserved Instance, per hour
(for example, 0.84).
}
}

\section{IncludeMarketplace}{

Include Reserved Instance Marketplace offerings in
the response.
}

\section{InstanceType}{

The instance type that the reservation
will cover (for example, \code{m1.small}). For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance types}
in the \emph{Amazon EC2 User Guide}.
}

\section{MaxDuration}{


The maximum duration (in seconds) to filter when searching for
offerings.

Default: 94608000 (3 years)
}

\section{MaxInstanceCount}{


The maximum number of instances to filter when searching for offerings.

Default: 20
}

\section{MinDuration}{


The minimum duration (in seconds) to filter when searching for
offerings.

Default: 2592000 (1 month)
}

\section{OfferingClass}{

The offering class of the Reserved Instance. Can be
\code{standard} or \code{convertible}.
}

\section{ProductDescription}{

The Reserved Instance
product platform description. Instances that include \verb{(Amazon VPC)} in
the description are for use with Amazon VPC.
}

\section{ReservedInstancesOfferingId}{

One or
more Reserved Instances offering IDs.
}

\section{DryRun}{

Checks whether
you have the required permissions for the action, without actually
making the request, and provides an error response. If you have the
required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.
}

\section{InstanceTenancy}{


The tenancy of the instances covered by the reservation. A Reserved
Instance with a tenancy of \code{dedicated} is applied to instances that run
in a VPC on single-tenant hardware (i.e., Dedicated Instances).

\strong{Important:} The \code{host} value cannot be used with this parameter. Use
the \code{default} or \code{dedicated} values only.

Default: \code{default}
}

\section{MaxResults}{


The maximum number of results to return for the request in a single
page. The remaining results of the initial request can be seen by
sending another request with the returned \code{NextToken} value. The maximum
is 100.

Default: 100
}

\section{OfferingType}{

The Reserved Instance offering type. If you
are using tools that predate the 2011-11-01 API version, you only have
access to the \verb{Medium Utilization} Reserved Instance offering type.
}

