% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_describe_traffic_mirror_filters}
\alias{ec2_describe_traffic_mirror_filters}
\title{Describe Traffic Mirror Filters}
\usage{
ec2_describe_traffic_mirror_filters(
  TrafficMirrorFilterId = NULL,
  DryRun = NULL,
  Filter = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TrafficMirrorFilterId}{List. The ID of the Traffic Mirror filter.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{Filter}{Named list where the name is the filter name and the value is the
filter's value. The value can be a vector or a list object (see below)[optional]}

\item{MaxResults}{Integer. The maximum number of results to return with a single call.[optional]}

\item{NextToken}{Characters, The token for the next page of results[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Describes one or more Traffic Mirror
filters.
}
\section{TrafficMirrorFilterId}{

The ID of the Traffic Mirror
filter.
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

\section{Filter}{


One or more filters. The possible values are:
\itemize{
\item \code{description}: The Traffic Mirror filter description.
\item \code{traffic-mirror-filter-id}: The ID of the Traffic Mirror filter.
}
}

\section{MaxResults}{

The maximum number of results to return with a
single call. To retrieve the remaining results, make another call with
the returned \code{nextToken} value.
}

