% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_disassociate_transit_gateway_multicast_domain}
\alias{ec2_disassociate_transit_gateway_multicast_domain}
\title{Disassociate Transit Gateway Multicast Domain}
\usage{
ec2_disassociate_transit_gateway_multicast_domain(
  TransitGatewayMulticastDomainId = NULL,
  TransitGatewayAttachmentId = NULL,
  SubnetIds = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list()
)
}
\arguments{
\item{TransitGatewayMulticastDomainId}{String. The ID of the transit gateway multicast domain.[optional]}

\item{TransitGatewayAttachmentId}{String. The ID of the attachment.[optional]}

\item{SubnetIds}{List. The IDs of the subnets;[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}
}
\value{
A list object or a character vector
}
\description{
Disassociates
the specified subnets from the transit gateway multicast domain.
}
\section{TransitGatewayMulticastDomainId}{

The ID of the transit gateway multicast
domain.
}

\section{TransitGatewayAttachmentId}{

The ID of the
attachment.
}

\section{SubnetIds}{

The IDs of the
subnets;
}

\section{DryRun}{

Checks whether you have the required
permissions for the action, without actually making the request, and
provides an error response. If you have the required permissions, the
error response is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

